/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core.metrics;

import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.metrics.MetricsCollector;
import com.byteplus.rec.core.metrics.protocol.ByteplusRecSdkMetrics;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(MetricsReporter.class);
    private final OkHttpClient httpCli;

    protected MetricsReporter(MetricsCollector.MetricsCfg metricsCfg) {
        this.httpCli = new OkHttpClient.Builder().connectTimeout(metricsCfg.getHttpTimeout().toMillis(), TimeUnit.MILLISECONDS).writeTimeout(metricsCfg.getHttpTimeout().toMillis(), TimeUnit.MILLISECONDS).readTimeout(metricsCfg.getHttpTimeout().toMillis(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).build();
    }

    protected void report(ByteplusRecSdkMetrics.MetricMessage metricMessage, String url) throws BizException {
        byte[] reqBodyBytes = metricMessage.toByteArray();
        Headers headers = this.buildMetricsHeaders();
        this.doRequest(url, reqBodyBytes, headers);
    }

    protected void report(ByteplusRecSdkMetrics.MetricLogMessage metricLogMessage, String url) throws BizException {
        byte[] reqBodyBytes = metricLogMessage.toByteArray();
        Headers headers = this.buildMetricsHeaders();
        this.doRequest(url, reqBodyBytes, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(String url, byte[] reqBodyBytes, Headers headers) throws BizException {
        Request request = new Request.Builder().url(url).headers(headers).post(RequestBody.create(reqBodyBytes)).build();
        Response response = null;
        int i = 0;
        while (true) {
            block12: {
                response = this.httpCli.newCall(request).execute();
                if (response.code() != 200) break block12;
                if (response != null) {
                    response.close();
                }
                return;
            }
            try {
                try {
                    ResponseBody rspBody = response.body();
                    if (Objects.isNull(rspBody)) {
                        throw new BizException("rsp body is null");
                    }
                    throw new BizException(String.format("do http request fail, code:%d, rsp:%s", response.code(), new String(rspBody.bytes())));
                }
                catch (IOException e) {
                    if (!e.getMessage().toLowerCase().contains("timeout")) {
                        throw new BizException(e.toString());
                    }
                    if (i == 2) {
                        throw new BizException(e.toString());
                    }
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (response != null) {
                    response.close();
                }
                throw throwable;
            }
            ++i;
        }
    }

    private Headers buildMetricsHeaders() {
        return new Headers.Builder().set("Content-Type", "application/x-protobuf").set("Accept", "application/json").build();
    }
}

