/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.sdk.retail;

import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.HTTPClient;
import com.byteplus.rec.core.NetException;
import com.byteplus.rec.core.Option;
import com.byteplus.rec.core.Utils;
import com.byteplus.rec.sdk.retail.RetailClient;
import com.byteplus.rec.sdk.retail.protocol.ByteplusSaasRetail;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetailClientImpl
implements RetailClient {
    private static final Logger log = LoggerFactory.getLogger(RetailClientImpl.class);
    private static final String ERR_MSG_TOO_MANY_WRITE_ITEMS = String.format("Only can receive max to %d items in one write request", 2000);
    private static final String ERR_MSG_TOO_MANY_FINISH_DATES = String.format("Only can receive max to %d dates in one finish request", 100);
    private final HTTPClient httpClient;
    private final String projectID;

    protected RetailClientImpl(HTTPClient httpClient, String projectID) {
        this.httpClient = httpClient;
        this.projectID = projectID;
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeUsers(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasRetail.WriteDataRequest writeRequest = request.toBuilder().setTopic("user").build();
        return this.doWriteData(writeRequest, "/RetailSaaS/WriteUsers", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse finishWriteUsers(ByteplusSaasRetail.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasRetail.FinishWriteDataRequest finishRequest = request.toBuilder().setTopic("user").build();
        return this.doFinishData(finishRequest, "/RetailSaaS/FinishWriteUsers", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeProducts(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasRetail.WriteDataRequest writeRequest = request.toBuilder().setTopic("goods").build();
        return this.doWriteData(writeRequest, "/RetailSaaS/WriteProducts", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse finishWriteProducts(ByteplusSaasRetail.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasRetail.FinishWriteDataRequest finishRequest = request.toBuilder().setTopic("goods").build();
        return this.doFinishData(finishRequest, "/RetailSaaS/FinishWriteProducts", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeUserEvents(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasRetail.WriteDataRequest writeRequest = request.toBuilder().setTopic("behavior").build();
        return this.doWriteData(writeRequest, "/RetailSaaS/WriteUserEvents", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse finishWriteUserEvents(ByteplusSaasRetail.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasRetail.FinishWriteDataRequest finishRequest = request.toBuilder().setTopic("behavior").build();
        return this.doFinishData(finishRequest, "/RetailSaaS/FinishWriteUserEvents", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeOthers(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doWriteData(request, "/RetailSaaS/WriteOthers", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse finishWriteOthers(ByteplusSaasRetail.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doFinishData(request, "/RetailSaaS/FinishWriteOthers", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse finishWrite(ByteplusSaasRetail.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doFinishData(request, "/RetailSaaS/FinishWrite", opts);
    }

    private ByteplusSaasRetail.WriteResponse doWriteData(ByteplusSaasRetail.WriteDataRequest request, String path, Option ... opts) throws NetException, BizException {
        if (Objects.nonNull(this.projectID) && request.getProjectId().length() == 0) {
            request = request.toBuilder().setProjectId(this.projectID).build();
        }
        this.checkWriteDataRequest(request);
        ByteplusSaasRetail.WriteResponse response = this.httpClient.doPBRequest(path, request, ByteplusSaasRetail.WriteResponse.parser(), Option.conv2Options(opts));
        log.debug("[ByteplusSDK][WriteData] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkWriteDataRequest(ByteplusSaasRetail.WriteDataRequest request) throws BizException {
        if (Utils.isEmptyString(request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString(request.getStage())) {
            throw new BizException("stage is empty");
        }
        if (request.getDataCount() > 2000) {
            throw new BizException(ERR_MSG_TOO_MANY_WRITE_ITEMS);
        }
    }

    private ByteplusSaasRetail.WriteResponse doFinishData(ByteplusSaasRetail.FinishWriteDataRequest request, String path, Option ... opts) throws NetException, BizException {
        if (Objects.nonNull(this.projectID) && request.getProjectId().length() == 0) {
            request = request.toBuilder().setProjectId(this.projectID).build();
        }
        this.checkFinishWriteRequest(request);
        ByteplusSaasRetail.WriteResponse response = this.httpClient.doPBRequest(path, request, ByteplusSaasRetail.WriteResponse.parser(), Option.conv2Options(opts));
        log.debug("[ByteplusSDK][FinishWriteData] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkFinishWriteRequest(ByteplusSaasRetail.FinishWriteDataRequest request) throws BizException {
        if (Utils.isEmptyString(request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString(request.getStage())) {
            throw new BizException("stage is empty");
        }
        if (Utils.isEmptyString(request.getTopic())) {
            throw new BizException("topic is empty");
        }
        if (request.getDataDatesCount() > 100) {
            throw new BizException(ERR_MSG_TOO_MANY_FINISH_DATES);
        }
    }

    @Override
    public ByteplusSaasRetail.PredictResponse predict(ByteplusSaasRetail.PredictRequest request, Option ... opts) throws NetException, BizException {
        if (Objects.nonNull(this.projectID) && request.getProjectId().length() == 0) {
            request = request.toBuilder().setProjectId(this.projectID).build();
        }
        this.checkPredictRequest(request);
        ByteplusSaasRetail.PredictResponse response = this.httpClient.doPBRequest("/RetailSaaS/Predict", request, ByteplusSaasRetail.PredictResponse.parser(), Option.conv2Options(opts));
        log.debug("[ByteplusSDK][Predict] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkPredictRequest(ByteplusSaasRetail.PredictRequest request) throws BizException {
        if (Utils.isEmptyString(request.getProjectId())) {
            throw new BizException("project id is empty");
        }
    }

    @Override
    public ByteplusSaasRetail.AckServerImpressionsResponse ackServerImpressions(ByteplusSaasRetail.AckServerImpressionsRequest request, Option ... opts) throws NetException, BizException {
        if (Objects.nonNull(this.projectID) && request.getProjectId().length() == 0) {
            request = request.toBuilder().setProjectId(this.projectID).build();
        }
        this.checkAckRequest(request);
        ByteplusSaasRetail.AckServerImpressionsResponse response = this.httpClient.doPBRequest("/RetailSaaS/AckServerImpressions", request, ByteplusSaasRetail.AckServerImpressionsResponse.parser(), Option.conv2Options(opts));
        log.debug("[ByteplusSDK][AckImpressions] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkAckRequest(ByteplusSaasRetail.AckServerImpressionsRequest request) throws BizException {
        if (Utils.isEmptyString(request.getProjectId())) {
            throw new BizException("project id is empty");
        }
    }

    @Override
    public final void release() {
        this.httpClient.shutdown();
    }
}

