/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.sdk.retail.example;

import com.alibaba.fastjson.JSON;
import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.NetException;
import com.byteplus.rec.core.Option;
import com.byteplus.rec.core.StatusHelper;
import com.byteplus.rec.sdk.region.Region;
import com.byteplus.rec.sdk.retail.RetailClient;
import com.byteplus.rec.sdk.retail.RetailClientBuilder;
import com.byteplus.rec.sdk.retail.example.MockHelper;
import com.byteplus.rec.sdk.retail.example.entity.DemoProduct;
import com.byteplus.rec.sdk.retail.example.entity.DemoUser;
import com.byteplus.rec.sdk.retail.example.entity.DemoUserEvent;
import com.byteplus.rec.sdk.retail.protocol.ByteplusSaasRetail;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static RetailClient client;
    private static final int DEFAULT_RETRY_TIMES = 2;
    private static final Duration DEFAULT_WRITE_TIMEOUT;
    private static final Duration DEFAULT_PREDICT_TIMEOUT;
    private static final Duration DEFAULT_FINISH_TIMEOUT;
    private static final Duration DEFAULT_ACK_IMPRESSIONS_TIMEOUT;
    public static final String PROJECT_ID = "*********";
    public static final String MODEL_ID = "*********";

    public static void main(String[] args) {
        Main.writeUsersExample();
        Main.writeProductsExample();
        Main.writeUserEventsExample();
        Main.recommendExample();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        client.release();
        System.exit(0);
    }

    public static void writeUsersExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.WriteDataRequest request = Main.buildWriteUsersRequest(1);
        Option[] opts = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = client.writeUsers(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("write user occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("write user success");
            return;
        }
        log.error("write user find failure info, msg:{} errItems:{}", (Object)response.getStatus(), response.getErrorsList());
    }

    private static ByteplusSaasRetail.WriteDataRequest buildWriteUsersRequest(int count) {
        List<DemoUser> users = MockHelper.mockUsers(count);
        ByteplusSaasRetail.WriteDataRequest.Builder requestBuilder = ByteplusSaasRetail.WriteDataRequest.newBuilder().setStage("trial");
        for (DemoUser user : users) {
            requestBuilder.addData(JSON.toJSONString((Object)user));
        }
        return requestBuilder.build();
    }

    public static void finishWriteUsersExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.FinishWriteDataRequest request = Main.buildFinishUserRequest();
        Option[] opts = Main.defaultOptions(DEFAULT_FINISH_TIMEOUT);
        try {
            response = client.finishWriteUsers(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("run finish occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("finish write user data");
            return;
        }
        log.error("fail to finish write user data, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getInitializationErrorString());
    }

    private static ByteplusSaasRetail.FinishWriteDataRequest buildFinishUserRequest() {
        return ByteplusSaasRetail.FinishWriteDataRequest.newBuilder().setStage("incremental_sync_daily").build();
    }

    private static void addFinishDate(List<ByteplusSaasRetail.Date> dateMapList, LocalDate date) {
        dateMapList.add(Main.buildFinishDate(date));
    }

    private static ByteplusSaasRetail.Date buildFinishDate(LocalDate date) {
        return ByteplusSaasRetail.Date.newBuilder().setYear(date.getYear()).setMonth(date.getMonthValue()).setDay(date.getDayOfMonth()).build();
    }

    public static void writeProductsExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.WriteDataRequest request = Main.buildWriteProductsRequest(1);
        Option[] options = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = client.writeProducts(request, options);
        }
        catch (BizException | NetException e) {
            log.error("write product occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("write product success");
            return;
        }
        log.error("write product find failure info, msg:{} errItems:{}", (Object)response.getStatus(), response.getErrorsList());
    }

    private static ByteplusSaasRetail.WriteDataRequest buildWriteProductsRequest(int count) {
        List<DemoProduct> products = MockHelper.mockProducts(count);
        ByteplusSaasRetail.WriteDataRequest.Builder requestBuilder = ByteplusSaasRetail.WriteDataRequest.newBuilder().setStage("trial");
        for (DemoProduct product : products) {
            requestBuilder.addData(JSON.toJSONString((Object)product));
        }
        return requestBuilder.build();
    }

    public static void finishWriteProductsExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.FinishWriteDataRequest request = Main.buildFinishProductRequest();
        Option[] opts = Main.defaultOptions(DEFAULT_FINISH_TIMEOUT);
        try {
            response = client.finishWriteProducts(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("run finish occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("finish write product data");
            return;
        }
        log.error("fail to finish write product data, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getInitializationErrorString());
    }

    private static ByteplusSaasRetail.FinishWriteDataRequest buildFinishProductRequest() {
        return ByteplusSaasRetail.FinishWriteDataRequest.newBuilder().setStage("incremental_sync_daily").build();
    }

    public static void writeUserEventsExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.WriteDataRequest request = Main.buildWriteUserEventsRequest(1);
        Option[] options = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = client.writeUserEvents(request, options);
        }
        catch (BizException | NetException e) {
            log.error("write user events occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("write user events success");
            return;
        }
        log.error("write user events find failure info, msg:{} errItems:{}", (Object)response.getStatus(), response.getErrorsList());
    }

    private static ByteplusSaasRetail.WriteDataRequest buildWriteUserEventsRequest(int count) {
        List<DemoUserEvent> userEvents = MockHelper.mockUserEvents(count);
        ByteplusSaasRetail.WriteDataRequest.Builder requestBuilder = ByteplusSaasRetail.WriteDataRequest.newBuilder().setStage("trial");
        for (DemoUserEvent userEvent : userEvents) {
            requestBuilder.addData(JSON.toJSONString((Object)userEvent));
        }
        return requestBuilder.build();
    }

    public static void finishWriteUserEventsExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.FinishWriteDataRequest request = Main.buildFinishUserEventRequest();
        Option[] opts = Main.defaultOptions(DEFAULT_FINISH_TIMEOUT);
        try {
            response = client.finishWriteUserEvents(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("run finish occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("finish write user_event data");
            return;
        }
        log.error("fail to finish write user_event data, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getInitializationErrorString());
    }

    private static ByteplusSaasRetail.FinishWriteDataRequest buildFinishUserEventRequest() {
        LocalDate date = LocalDate.of(2022, 3, 1);
        return ByteplusSaasRetail.FinishWriteDataRequest.newBuilder().setStage("incremental_sync_daily").addAllDataDates(Main.buildDateList(date)).build();
    }

    private static List<ByteplusSaasRetail.Date> buildDateList(LocalDate date) {
        List<LocalDate> dateList = Collections.singletonList(date);
        ArrayList<ByteplusSaasRetail.Date> dates = new ArrayList<ByteplusSaasRetail.Date>();
        for (LocalDate everyDay : dateList) {
            Main.addFinishDate(dates, everyDay);
        }
        return dates;
    }

    public static void writeOthersExample() {
        ByteplusSaasRetail.WriteResponse response;
        String topic = "video";
        ByteplusSaasRetail.WriteDataRequest request = Main.buildWriteOthersRequest(topic);
        Option[] opts = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = client.writeOthers(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("write other data occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("write other data success");
            return;
        }
        log.error("write other data find failure info, msg:{} errItems:{}", (Object)response.getStatus(), response.getErrorsList());
    }

    private static ByteplusSaasRetail.WriteDataRequest buildWriteOthersRequest(String topic) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("field1", 1);
        data.put("field2", "value2");
        return ByteplusSaasRetail.WriteDataRequest.newBuilder().setStage("trial").setTopic(topic).addData(((Object)data).toString()).build();
    }

    public static void finishWriteOthersExample() {
        ByteplusSaasRetail.WriteResponse response;
        String topic = "video";
        ByteplusSaasRetail.FinishWriteDataRequest request = Main.buildFinishOthersRequest(topic);
        Option[] opts = Main.defaultOptions(DEFAULT_FINISH_TIMEOUT);
        try {
            response = client.finishWriteOthers(request, opts);
        }
        catch (BizException | NetException e) {
            log.error("run finish occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("finish writing data");
            return;
        }
        log.error("fail to finish, msg:{} errItems:{}", (Object)response.getStatus(), (Object)response.getInitializationErrorString());
    }

    private static ByteplusSaasRetail.FinishWriteDataRequest buildFinishOthersRequest(String topic) {
        LocalDate date = LocalDate.of(2022, 2, 1);
        return ByteplusSaasRetail.FinishWriteDataRequest.newBuilder().setStage("incremental_sync_daily").setTopic(topic).addAllDataDates(Main.buildDateList(date)).build();
    }

    public static void recommendExample() {
        ByteplusSaasRetail.PredictResponse response;
        ByteplusSaasRetail.PredictRequest predictRequest = Main.buildPredictRequest();
        Option[] predict_opts = Main.defaultOptions(DEFAULT_PREDICT_TIMEOUT);
        try {
            response = client.predict(predictRequest, predict_opts);
        }
        catch (Exception e) {
            log.error("predict occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        if (!StatusHelper.isSuccess((int)response.getStatus().getCode())) {
            log.error("predict find failure info, msg:{}", (Object)response.getStatus());
            return;
        }
        log.info("predict success");
        List<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> alteredProducts = Main.doSomethingWithPredictResult(response.getValue());
        ByteplusSaasRetail.AckServerImpressionsRequest ackRequest = Main.buildAckRequest(response.getRequestId(), predictRequest, alteredProducts);
        Option[] ack_opts = Main.defaultOptions(DEFAULT_ACK_IMPRESSIONS_TIMEOUT);
        try {
            client.ackServerImpressions(ackRequest, ack_opts);
        }
        catch (Exception e) {
            log.error("[AckServerImpressions] occur error, msg:{}", (Object)e.getMessage());
        }
    }

    private static ByteplusSaasRetail.PredictRequest buildPredictRequest() {
        ByteplusSaasRetail.Scene scene = ByteplusSaasRetail.Scene.newBuilder().setOffset(10).build();
        ByteplusSaasRetail.Product rootProduct = MockHelper.mockPredictProduct();
        ByteplusSaasRetail.Device device = MockHelper.mockDevice();
        ByteplusSaasRetail.PredictRequest.Context context = ByteplusSaasRetail.PredictRequest.Context.newBuilder().setRootProduct(rootProduct).setDevice(device).addAllCandidateProductIds(Arrays.asList("632462", "632463")).build();
        return ByteplusSaasRetail.PredictRequest.newBuilder().setModelId("*********").setUserId("1457789").setSize(20).setScene(scene).setContext(context).build();
    }

    private static List<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> doSomethingWithPredictResult(ByteplusSaasRetail.PredictResult predictResult) {
        return Main.conv2AlteredProducts(predictResult.getResponseProductsList());
    }

    @NotNull
    private static List<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> conv2AlteredProducts(List<ByteplusSaasRetail.PredictResult.ResponseProduct> products) {
        if (Objects.isNull(products) || products.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> alteredProducts = new ArrayList<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct>(products.size());
        for (int i = 0; i < products.size(); ++i) {
            ByteplusSaasRetail.PredictResult.ResponseProduct responseProduct = products.get(i);
            ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct alteredProduct = ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct.newBuilder().setAlteredReason("kept").setProductId(responseProduct.getProductId()).setRank(i + 1).build();
            alteredProducts.add(alteredProduct);
        }
        return alteredProducts;
    }

    private static ByteplusSaasRetail.AckServerImpressionsRequest buildAckRequest(String predictRequestId, ByteplusSaasRetail.PredictRequest predictRequest, List<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> alteredProducts) {
        return ByteplusSaasRetail.AckServerImpressionsRequest.newBuilder().setModelId(predictRequest.getModelId()).setPredictRequestId(predictRequestId).setUserId(predictRequest.getUserId()).setScene(predictRequest.getScene()).addAllAlteredProducts(alteredProducts).build();
    }

    private static Option[] defaultOptions(Duration timeout) {
        return new Option[]{Option.withRequestID((String)UUID.randomUUID().toString()), Option.withTimeout((Duration)timeout)};
    }

    static {
        DEFAULT_WRITE_TIMEOUT = Duration.ofMillis(800L);
        DEFAULT_PREDICT_TIMEOUT = Duration.ofMillis(800L);
        DEFAULT_FINISH_TIMEOUT = Duration.ofMillis(800L);
        DEFAULT_ACK_IMPRESSIONS_TIMEOUT = Duration.ofMillis(800L);
        try {
            client = new RetailClientBuilder().accountID("*********").projectID("*********").region(Region.SG).authAK("*********").authSK("*********").build();
        }
        catch (BizException e) {
            log.error("fail to create byteplus rec client", (Throwable)e);
        }
    }
}

