/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.sdk.retail;

import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.HTTPClient;
import com.byteplus.rec.core.IRegion;
import com.byteplus.rec.core.Utils;
import com.byteplus.rec.sdk.retail.RetailClientImpl;
import java.util.List;
import java.util.Objects;

public class RetailClientBuilder {
    private static final String BYTEPLUS_AUTH_SERVICE = "byteplus_recommend";
    private String tenantID;
    private String projectID;
    private String airAuthToken;
    private String authAK;
    private String authSK;
    private String schema;
    private List<String> hosts;
    private IRegion region;

    public RetailClientBuilder accountID(String accountID) {
        this.tenantID = accountID;
        return this;
    }

    public RetailClientImpl build() throws BizException {
        this.checkRequiredField();
        HTTPClient httpClient = HTTPClient.builder().tenantID(this.tenantID).projectID(this.projectID).airAuthToken(this.airAuthToken).authAK(this.authAK).authSK(this.authSK).schema(this.schema).hosts(this.hosts).region(this.region).useAirAuth(this.isUseAirAuth()).authService(BYTEPLUS_AUTH_SERVICE).build();
        return new RetailClientImpl(httpClient, this.projectID);
    }

    private boolean isUseAirAuth() {
        return Utils.isAllEmptyString((String[])new String[]{this.authAK, this.authSK}) && Utils.noneEmptyString((String[])new String[]{this.airAuthToken});
    }

    private void checkRequiredField() throws BizException {
        if (Objects.isNull(this.projectID)) {
            throw new BizException("project id is empty");
        }
    }

    public RetailClientBuilder tenantID(String tenantID) {
        this.tenantID = tenantID;
        return this;
    }

    public RetailClientBuilder projectID(String projectID) {
        this.projectID = projectID;
        return this;
    }

    public RetailClientBuilder airAuthToken(String airAuthToken) {
        this.airAuthToken = airAuthToken;
        return this;
    }

    public RetailClientBuilder authAK(String authAK) {
        this.authAK = authAK;
        return this;
    }

    public RetailClientBuilder authSK(String authSK) {
        this.authSK = authSK;
        return this;
    }

    public RetailClientBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public RetailClientBuilder hosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    public RetailClientBuilder region(IRegion region) {
        this.region = region;
        return this;
    }
}

