/*
 * Decompiled with CFR 0.152.
 */
package com.cardinity.json;

import com.cardinity.exceptions.CardinityClientException;
import com.cardinity.json.UtcDateTypeAdapter;
import com.cardinity.model.Card;
import com.cardinity.model.Payment;
import com.cardinity.model.PaymentInstrument;
import com.cardinity.model.Threeds2AuthorizationInformation;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Date;

public class PaymentDeserializer
implements JsonDeserializer<Payment> {
    private static final String PAYMENT_METHOD_PROP = "payment_method";
    private static final String PAYMENT_INSTRUMENT_PROP = "payment_instrument";
    private static final String THREEDS2_DATA_PROP = "threeds2_data";
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Date.class, (Object)new UtcDateTypeAdapter()).create();

    public Payment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject paymentObject = json.getAsJsonObject();
        String paymentMethod = paymentObject.getAsJsonPrimitive(PAYMENT_METHOD_PROP).getAsString();
        if (!paymentMethod.equals("card")) {
            throw new CardinityClientException("DeserializationException: invalid payment method");
        }
        Class<Card> clazz = Card.class;
        PaymentInstrument instrument = (PaymentInstrument)context.deserialize(paymentObject.get(PAYMENT_INSTRUMENT_PROP), clazz);
        paymentObject.remove(PAYMENT_INSTRUMENT_PROP);
        Payment payment = (Payment)GSON.fromJson((JsonElement)paymentObject, Payment.class);
        payment.setPaymentInstrument(instrument);
        payment.setThreeds2Data(null);
        Threeds2AuthorizationInformation threeds2AuthorizationInformation = (Threeds2AuthorizationInformation)context.deserialize(paymentObject.get(THREEDS2_DATA_PROP), Threeds2AuthorizationInformation.class);
        payment.setThreeds2AuthorizationInformation(threeds2AuthorizationInformation);
        return payment;
    }
}

