/*
 * Decompiled with CFR 0.152.
 */
package com.cardinity.rest;

import com.cardinity.rest.RestResource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;

public final class URLUtils {
    private static final String URL_SEPARATOR = "/";

    private URLUtils() {
    }

    public static String buildUrl() {
        return URLUtils.buildCardinityUrl(null, null, null);
    }

    public static String buildUrl(UUID paymentId) {
        return URLUtils.buildCardinityUrl(paymentId, null, null);
    }

    public static String buildUrl(UUID paymentId, RestResource.Resource resource) {
        return URLUtils.buildCardinityUrl(paymentId, resource, null);
    }

    public static String buildUrl(UUID paymentId, RestResource.Resource resource, UUID actionID) {
        return URLUtils.buildCardinityUrl(paymentId, resource, actionID);
    }

    private static String buildCardinityUrl(UUID paymentId, RestResource.Resource action, UUID actionId) {
        StringBuilder url = new StringBuilder("https://api.cardinity.com").append(URL_SEPARATOR).append("v1").append(URL_SEPARATOR).append((Object)RestResource.Resource.PAYMENTS);
        if (paymentId != null) {
            url.append(URL_SEPARATOR);
            url.append(paymentId);
            if (action != null) {
                url.append(URL_SEPARATOR);
                url.append((Object)action);
                if (actionId != null) {
                    url.append(URL_SEPARATOR);
                    url.append(actionId);
                }
            }
        }
        return url.toString().toLowerCase();
    }

    public static String formatURL(String url, String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    public static String buildQueryParam(String key, String value) throws UnsupportedEncodingException {
        return String.format("%s=%s", URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(value, "UTF-8"));
    }
}

