/*
 * Decompiled with CFR 0.152.
 */
package com.cardinity.rest;

import com.cardinity.exceptions.CardinityClientException;
import com.cardinity.model.CardinityError;
import com.cardinity.model.Response;
import com.cardinity.model.Result;
import com.cardinity.oauth.OAuthProvider;
import com.cardinity.rest.RestClient;
import com.cardinity.rest.RestResource;
import com.cardinity.rest.URLUtils;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class CardinityRestClient
implements RestClient {
    private final OAuthProvider oAuthProvider;

    public CardinityRestClient(OAuthProvider oAuthProvider) {
        this.oAuthProvider = oAuthProvider;
    }

    @Override
    public <T> Result<T> sendRequest(RestResource.RequestMethod method, String url, TypeToken<T> clazz, Object requestObject) {
        return this._sendRequest(method, url, clazz, requestObject, null);
    }

    @Override
    public <T> Result<T> sendRequest(RestResource.RequestMethod method, String url, TypeToken<T> clazz) {
        return this._sendRequest(method, url, clazz, null, null);
    }

    @Override
    public <T> Result<T> sendRequest(RestResource.RequestMethod method, String url, TypeToken<T> clazz, Map<String, String> params) {
        boolean methodGet = method == RestResource.RequestMethod.GET;
        return this._sendRequest(method, url, clazz, methodGet ? null : params, methodGet ? params : null);
    }

    private <T> Result<T> _sendRequest(RestResource.RequestMethod method, String url, TypeToken<T> clazz, Object requestObject, Map<String, String> params) {
        Result<Object> result;
        Response response = this.getResponse(method, url, requestObject, params);
        int responseCode = response.getCode();
        String responseBody = response.getBody();
        if (responseCode < 200 || responseCode >= 300 && responseCode != 402) {
            result = new Result((CardinityError)RestResource.GSON.fromJson(responseBody, CardinityError.class));
        } else {
            Object resultObject = RestResource.GSON.fromJson(responseBody, clazz.getType());
            result = new Result<Object>(resultObject);
        }
        return result;
    }

    private Response getResponse(RestResource.RequestMethod method, String url, Object requestObject, Map<String, String> params) {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = CardinityRestClient.createGetConnection(url, params, this.oAuthProvider.buildAuthorizationHeader(method, url, params));
                    break;
                }
                case POST: {
                    conn = CardinityRestClient.createPostPatchConnection(url, CardinityRestClient.buildRequestBody(requestObject), true, this.oAuthProvider.buildAuthorizationHeader(method, url));
                    break;
                }
                case PATCH: {
                    conn = CardinityRestClient.createPostPatchConnection(url, CardinityRestClient.buildRequestBody(requestObject), false, this.oAuthProvider.buildAuthorizationHeader(method, url));
                    break;
                }
                default: {
                    throw new CardinityClientException("Unrecognized HTTP request type.");
                }
            }
            int responseCode = conn.getResponseCode();
            String responseBody = responseCode >= 200 && responseCode < 300 ? CardinityRestClient.getResponseBody(conn.getInputStream()) : CardinityRestClient.getResponseBody(conn.getErrorStream());
            Response response = new Response(responseCode, responseBody);
            return response;
        }
        catch (UnsupportedEncodingException e) {
            throw new CardinityClientException("UnsupportedEncodingException: failed to encode data in .UTF-8");
        }
        catch (IOException e) {
            throw new CardinityClientException("IOException: check connectivity to cardinity servers.");
        }
        catch (GeneralSecurityException e) {
            throw new CardinityClientException("OAuthException: failed to sign request.");
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static HttpURLConnection createGetConnection(String url, Map<String, String> params, String authorizationHeader) throws IOException {
        String getURL = CardinityRestClient.createUrl(url, params);
        HttpURLConnection conn = CardinityRestClient.createConnection(getURL);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", authorizationHeader);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostPatchConnection(String url, String query, Boolean post, String authorizationHeader) throws IOException {
        HttpURLConnection conn = CardinityRestClient.createConnection(url);
        conn.setDoOutput(true);
        CardinityRestClient.setRequestMethodBypassingJREMethodLimitation(conn, post != false ? "POST" : "PATCH");
        conn.setRequestProperty("Content-Type", String.format("application/json;charset=%s", "UTF-8"));
        conn.setRequestProperty("Authorization", authorizationHeader);
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(query.getBytes("UTF-8"));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return conn;
    }

    private static HttpURLConnection createConnection(String url) throws IOException {
        URL cardinityURL = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)cardinityURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : CardinityRestClient.getDefaultHeaders().entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static String getResponseBody(InputStream is) throws IOException {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        String body = s.hasNext() ? s.next() : "";
        is.close();
        return body;
    }

    private static Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", "UTF-8");
        headers.put("Accept", "application/json");
        headers.put("User-Agent", String.format("cardinity-java-client-%s", "0.1"));
        headers.put("Cardinity-Version", "v1");
        return headers;
    }

    private static String buildRequestBody(Object object) {
        if (object != null) {
            return RestResource.GSON.toJson(object);
        }
        return "";
    }

    private static String createUrl(String url, Map<String, String> params) throws UnsupportedEncodingException {
        if (params == null) {
            return url;
        }
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(URLUtils.buildQueryParam(entry.getKey(), entry.getValue()));
        }
        return URLUtils.formatURL(url, queryStringBuffer.toString());
    }

    private static void setRequestMethodBypassingJREMethodLimitation(HttpURLConnection httpURLConnection, String method) {
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException pe) {
            Class<?> connectionClass = httpURLConnection.getClass();
            try {
                Field delegateField = connectionClass.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                HttpURLConnection delegateConnection = (HttpURLConnection)delegateField.get(httpURLConnection);
                CardinityRestClient.setRequestMethodBypassingJREMethodLimitation(delegateConnection, method);
            }
            catch (NoSuchFieldException delegateConnection) {
            }
            catch (IllegalArgumentException e) {
                throw new CardinityClientException("RequestMethodException: failed to set request method.");
            }
            catch (IllegalAccessException e) {
                throw new CardinityClientException("RequestMethodException: failed to set request method.");
            }
            try {
                while (connectionClass != null) {
                    Field methodField;
                    try {
                        methodField = connectionClass.getDeclaredField("method");
                    }
                    catch (NoSuchFieldException e) {
                        connectionClass = connectionClass.getSuperclass();
                        continue;
                    }
                    methodField.setAccessible(true);
                    methodField.set(httpURLConnection, method);
                }
            }
            catch (Exception e) {
                throw new CardinityClientException("RequestMethodException: failed to set request method.");
            }
        }
    }
}

