/*
 * Decompiled with CFR 0.152.
 */
package com.cardinity;

import com.cardinity.exceptions.ValidationException;
import com.cardinity.model.Chargeback;
import com.cardinity.model.Payment;
import com.cardinity.model.Refund;
import com.cardinity.model.Result;
import com.cardinity.model.Settlement;
import com.cardinity.model.Void;
import com.cardinity.oauth.CardinityOAuthProvider;
import com.cardinity.rest.CardinityRestClient;
import com.cardinity.rest.RestClient;
import com.cardinity.rest.RestResource;
import com.cardinity.rest.URLUtils;
import com.cardinity.validators.ChargebackValidator;
import com.cardinity.validators.PaymentValidator;
import com.cardinity.validators.RefundValidator;
import com.cardinity.validators.SettlementValidator;
import com.cardinity.validators.ValidationUtils;
import com.cardinity.validators.Validator;
import com.cardinity.validators.VoidValidator;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class CardinityClient {
    private static final String MESSAGE_PAYMENT_ID_MISSING = "paymentID must be not null.";
    private static final TypeToken<Payment> PAYMENT_TYPE = new TypeToken<Payment>(){};
    private static final TypeToken<List<Payment>> PAYMENT_LIST_TYPE = new TypeToken<List<Payment>>(){};
    private static final TypeToken<Refund> REFUND_TYPE = new TypeToken<Refund>(){};
    private static final TypeToken<List<Refund>> REFUND_LIST_TYPE = new TypeToken<List<Refund>>(){};
    private static final TypeToken<Settlement> SETTLEMENT_TYPE = new TypeToken<Settlement>(){};
    private static final TypeToken<List<Settlement>> SETTLEMENT_LIST_TYPE = new TypeToken<List<Settlement>>(){};
    private static final TypeToken<Void> VOID_TYPE = new TypeToken<Void>(){};
    private static final TypeToken<List<Void>> VOID_LIST_TYPE = new TypeToken<List<Void>>(){};
    private static final TypeToken<Chargeback> CHARGEBACK_TYPE = new TypeToken<Chargeback>(){};
    private static final TypeToken<List<Chargeback>> CHARGEBACK_LIST_TYPE = new TypeToken<List<Chargeback>>(){};
    private static final Validator<Payment> paymentValidator = new PaymentValidator();
    private static final Validator<Refund> refundValidator = new RefundValidator();
    private static final Validator<Settlement> settlementValidator = new SettlementValidator();
    private static final Validator<Void> voidValidator = new VoidValidator();
    private static final Validator<Chargeback> chargebackValidator = new ChargebackValidator();
    private final RestClient restClient;

    public CardinityClient(String consumerKey, String consumerSecret) {
        if (ValidationUtils.isBlank(consumerKey) || ValidationUtils.isBlank(consumerSecret)) {
            throw new ValidationException("Consumer key and consumer secret must be not null");
        }
        this.restClient = new CardinityRestClient(new CardinityOAuthProvider(consumerKey, consumerSecret));
    }

    CardinityClient(RestClient restClient) {
        if (restClient == null) {
            throw new ValidationException("Rest client must be not null");
        }
        this.restClient = restClient;
    }

    public Result<Payment> createPayment(Payment payment) {
        paymentValidator.validate(payment);
        return this.restClient.sendRequest(RestResource.RequestMethod.POST, URLUtils.buildUrl(), PAYMENT_TYPE, payment);
    }

    public Result<Payment> finalizePayment(UUID paymentId, String authorizeData) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        if (ValidationUtils.isBlank(authorizeData)) {
            throw new ValidationException("authorizeData is mandatory.");
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.PATCH, URLUtils.buildUrl(paymentId), PAYMENT_TYPE, Collections.singletonMap("authorize_data", authorizeData));
    }

    public Result<Payment> finalizePaymentV2(UUID paymentId, String cRes) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        if (ValidationUtils.isBlank(cRes)) {
            throw new ValidationException("cRes is mandatory.");
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.PATCH, URLUtils.buildUrl(paymentId), PAYMENT_TYPE, Collections.singletonMap("cres", cRes));
    }

    public Result<Payment> getPayment(UUID paymentId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId), PAYMENT_TYPE);
    }

    public Result<List<Payment>> getPayments() {
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(), PAYMENT_LIST_TYPE);
    }

    public Result<List<Payment>> getPayments(int limit) {
        if (!ValidationUtils.validateInteger(limit, 1, 100)) {
            throw new ValidationException("Limit must be a positive value between 1 and 100");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(), PAYMENT_LIST_TYPE, params);
    }

    public Result<Refund> createRefund(UUID paymentId, Refund refund) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        refundValidator.validate(refund);
        return this.restClient.sendRequest(RestResource.RequestMethod.POST, URLUtils.buildUrl(paymentId, RestResource.Resource.REFUNDS), REFUND_TYPE, refund);
    }

    public Result<Refund> getRefund(UUID paymentId, UUID refundId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        if (refundId == null) {
            throw new ValidationException("refundId must be not null.");
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId, RestResource.Resource.REFUNDS, refundId), REFUND_TYPE);
    }

    public Result<List<Refund>> getRefunds(UUID paymentId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId, RestResource.Resource.REFUNDS), REFUND_LIST_TYPE);
    }

    public Result<Settlement> createSettlement(UUID paymentId, Settlement settlement) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        settlementValidator.validate(settlement);
        return this.restClient.sendRequest(RestResource.RequestMethod.POST, URLUtils.buildUrl(paymentId, RestResource.Resource.SETTLEMENTS), SETTLEMENT_TYPE, settlement);
    }

    public Result<Settlement> getSettlement(UUID paymentId, UUID settlementId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        if (settlementId == null) {
            throw new ValidationException("settlementId must be not null.");
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId, RestResource.Resource.SETTLEMENTS, settlementId), SETTLEMENT_TYPE);
    }

    public Result<List<Settlement>> getSettlements(UUID paymentId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId, RestResource.Resource.SETTLEMENTS), SETTLEMENT_LIST_TYPE);
    }

    public Result<Void> createVoid(UUID paymentId, Void voidP) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        voidValidator.validate(voidP);
        return this.restClient.sendRequest(RestResource.RequestMethod.POST, URLUtils.buildUrl(paymentId, RestResource.Resource.VOIDS), VOID_TYPE, voidP);
    }

    public Result<Void> getVoid(UUID paymentId, UUID voidId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        if (voidId == null) {
            throw new ValidationException("voidId must be not null.");
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId, RestResource.Resource.VOIDS, voidId), VOID_TYPE);
    }

    public Result<List<Void>> getVoids(UUID paymentId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId, RestResource.Resource.VOIDS), VOID_LIST_TYPE);
    }

    public Result<Chargeback> createChargeback(UUID paymentId, Chargeback chargeback) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        chargebackValidator.validate(chargeback);
        return this.restClient.sendRequest(RestResource.RequestMethod.POST, URLUtils.buildUrl(paymentId, RestResource.Resource.CHARGEBACKS), CHARGEBACK_TYPE, chargeback);
    }

    public Result<Chargeback> getChargeback(UUID paymentId, UUID chargebackId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        if (chargebackId == null) {
            throw new ValidationException("chargebackId must be not null.");
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId, RestResource.Resource.CHARGEBACKS, chargebackId), CHARGEBACK_TYPE);
    }

    public Result<List<Chargeback>> getChargebacks(UUID paymentId) {
        if (paymentId == null) {
            throw new ValidationException(MESSAGE_PAYMENT_ID_MISSING);
        }
        return this.restClient.sendRequest(RestResource.RequestMethod.GET, URLUtils.buildUrl(paymentId, RestResource.Resource.CHARGEBACKS), CHARGEBACK_LIST_TYPE);
    }
}

