/*
 * Decompiled with CFR 0.152.
 */
package com.cardinity.oauth;

import com.cardinity.oauth.HmacOAuthSigner;
import com.cardinity.oauth.OAuthProvider;
import com.cardinity.oauth.OAuthSigner;
import com.cardinity.oauth.OAuthUtils;
import com.cardinity.rest.RestResource;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.TreeMap;

public final class CardinityOAuthProvider
implements OAuthProvider {
    private static final String OAUTH_VERSION = "1.0";
    private static final SecureRandom RANDOM = new SecureRandom();
    private final OAuthSigner signer = new HmacOAuthSigner();
    private final String consumerKey;
    private final String consumerSecret;

    public CardinityOAuthProvider(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    @Override
    public String buildAuthorizationHeader(RestResource.RequestMethod requestMethod, String requestUrl) throws GeneralSecurityException, UnsupportedEncodingException {
        return this.buildAuthorizationHeader(requestMethod, requestUrl, null);
    }

    @Override
    public String buildAuthorizationHeader(RestResource.RequestMethod requestMethod, String requestUrl, Map<String, String> queryParameters) throws GeneralSecurityException, UnsupportedEncodingException {
        String signatureMethod = this.signer.getSignatureMethod();
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("oauth_consumer_key", this.consumerKey);
        parameters.put("oauth_nonce", this.computeNonce());
        parameters.put("oauth_signature_method", signatureMethod);
        parameters.put("oauth_timestamp", this.computeTimestamp());
        parameters.put("oauth_version", OAUTH_VERSION);
        if (queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                parameters.put(entry.getKey(), entry.getValue());
            }
        }
        StringBuilder parametersBuf = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : parameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                parametersBuf.append('&');
            }
            parametersBuf.append((String)entry.getKey());
            String value = (String)entry.getValue();
            if (value == null) continue;
            parametersBuf.append('=').append(value);
        }
        String normalizedParameters = parametersBuf.toString();
        String signatureBaseString = (Object)((Object)requestMethod) + "&" + OAuthUtils.percentEncode(requestUrl) + "&" + OAuthUtils.percentEncode(normalizedParameters);
        String signature = this.signer.computeSignature(signatureBaseString, this.consumerSecret);
        parameters.put("oauth_signature", signature);
        StringBuilder headerBuf = new StringBuilder("OAuth");
        for (Map.Entry entry : parameters.entrySet()) {
            if (!((String)entry.getKey()).startsWith("oauth_")) continue;
            this.appendParameter(headerBuf, (String)entry.getKey(), (String)entry.getValue());
        }
        return headerBuf.substring(0, headerBuf.length() - 1);
    }

    private String computeNonce() {
        return Long.toHexString(Math.abs(RANDOM.nextLong()));
    }

    private String computeTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    private void appendParameter(StringBuilder buf, String name, String value) {
        if (value != null) {
            buf.append(' ').append(OAuthUtils.percentEncode(name)).append("=\"").append(OAuthUtils.percentEncode(value)).append("\",");
        }
    }
}

