/*
 * Decompiled with CFR 0.152.
 */
package com.cardinity.oauth;

import com.cardinity.oauth.OAuthSigner;
import com.cardinity.oauth.OAuthUtils;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class HmacOAuthSigner
implements OAuthSigner {
    @Override
    public String getSignatureMethod() {
        return "HMAC-SHA1";
    }

    @Override
    public String computeSignature(String signatureBaseString, String consumerSecret) throws GeneralSecurityException, UnsupportedEncodingException {
        String key = OAuthUtils.percentEncode(consumerSecret) + "&";
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKey);
        return DatatypeConverter.printBase64Binary((byte[])mac.doFinal(signatureBaseString.getBytes("UTF-8")));
    }
}

