/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.connections;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.connections.connectiontocourier.ConnectionToCourierClient;
import com.chrt.api.resources.connections.connectiontoforwarder.ConnectionToForwarderClient;
import com.chrt.api.resources.connections.connectiontoshipper.ConnectionToShipperClient;
import com.chrt.api.resources.connections.types.ConnectionsGetByHandleV1Response;
import com.chrt.api.types.CourierConnectionRes;
import com.chrt.api.types.ForwarderConnectionRes;
import com.chrt.api.types.ShipperConnectionRes;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class ConnectionsClient {
    protected final ClientOptions clientOptions;

    private final RawConnectionsClient rawClient;

    protected final Supplier<ConnectionToCourierClient> connectionToCourierClient;

    protected final Supplier<ConnectionToShipperClient> connectionToShipperClient;

    protected final Supplier<ConnectionToForwarderClient> connectionToForwarderClient;

    public ConnectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawConnectionsClient(clientOptions);
        this.connectionToCourierClient = Suppliers.memoize(() -> new ConnectionToCourierClient(clientOptions));
        this.connectionToShipperClient = Suppliers.memoize(() -> new ConnectionToShipperClient(clientOptions));
        this.connectionToForwarderClient = Suppliers.memoize(() -> new ConnectionToForwarderClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawConnectionsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists shipper organizations based on the caller's organization type. Couriers see connected shippers, forwarders see connected shippers. | () -&gt; (list[ShipperConnectionRes])
     */
    public List<ShipperConnectionRes> listShippersV1() {
        return this.rawClient.listShippersV1().body();
    }

    /**
     * Lists shipper organizations based on the caller's organization type. Couriers see connected shippers, forwarders see connected shippers. | () -&gt; (list[ShipperConnectionRes])
     */
    public List<ShipperConnectionRes> listShippersV1(RequestOptions requestOptions) {
        return this.rawClient.listShippersV1(requestOptions).body();
    }

    /**
     * Lists courier organizations based on the caller's organization type. Shippers see connected couriers, forwarders see connected couriers. | () -&gt; (list[CourierConnectionRes])
     */
    public List<CourierConnectionRes> listCouriersV1() {
        return this.rawClient.listCouriersV1().body();
    }

    /**
     * Lists courier organizations based on the caller's organization type. Shippers see connected couriers, forwarders see connected couriers. | () -&gt; (list[CourierConnectionRes])
     */
    public List<CourierConnectionRes> listCouriersV1(RequestOptions requestOptions) {
        return this.rawClient.listCouriersV1(requestOptions).body();
    }

    /**
     * Lists forwarder organizations based on the caller's organization type. Shippers see connected forwarders, couriers see connected forwarders. | () -&gt; (list[ForwarderConnectionRes])
     */
    public List<ForwarderConnectionRes> listForwardersV1() {
        return this.rawClient.listForwardersV1().body();
    }

    /**
     * Lists forwarder organizations based on the caller's organization type. Shippers see connected forwarders, couriers see connected forwarders. | () -&gt; (list[ForwarderConnectionRes])
     */
    public List<ForwarderConnectionRes> listForwardersV1(RequestOptions requestOptions) {
        return this.rawClient.listForwardersV1(requestOptions).body();
    }

    /**
     * Gets connection between caller's org and org with specified handle. | () -&gt; (ShipperCourierConnection1 | ShipperForwarderConnection1 | ForwarderCourierConnection1 | None)
     */
    public Optional<ConnectionsGetByHandleV1Response> getByHandleV1(String handle) {
        return this.rawClient.getByHandleV1(handle).body();
    }

    /**
     * Gets connection between caller's org and org with specified handle. | () -&gt; (ShipperCourierConnection1 | ShipperForwarderConnection1 | ForwarderCourierConnection1 | None)
     */
    public Optional<ConnectionsGetByHandleV1Response> getByHandleV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getByHandleV1(handle, requestOptions).body();
    }

    public ConnectionToCourierClient connectionToCourier() {
        return this.connectionToCourierClient.get();
    }

    public ConnectionToShipperClient connectionToShipper() {
        return this.connectionToShipperClient.get();
    }

    public ConnectionToForwarderClient connectionToForwarder() {
        return this.connectionToForwarderClient.get();
    }
}
