/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.connections.connectiontocourier;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.CreateConnectionReq;
import java.util.concurrent.CompletableFuture;

public class AsyncConnectionToCourierClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawConnectionToCourierClient rawClient;

    public AsyncConnectionToCourierClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawConnectionToCourierClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawConnectionToCourierClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates a new connection to a courier organization. Shippers and forwarders can initiate connections to couriers. | (CreateConnectionReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(CreateConnectionReq request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new connection to a courier organization. Shippers and forwarders can initiate connections to couriers. | (CreateConnectionReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(CreateConnectionReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }
}
