/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.courierpaydriverlineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.courierpaydriverlineitemgroups.addlineitems.AddLineItemsClient;
import com.chrt.api.resources.courierpaydriverlineitemgroups.removelineitems.RemoveLineItemsClient;
import com.chrt.api.types.CourierPayDriverLineItemGroup1;
import com.chrt.api.types.CourierPayDriverLineItemGroupCreateReq;
import com.chrt.api.types.CourierPayDriverLineItemGroupServerCreate1;
import java.util.function.Supplier;

public class CourierPayDriverLineItemGroupsClient {
    protected final ClientOptions clientOptions;

    private final RawCourierPayDriverLineItemGroupsClient rawClient;

    protected final Supplier<AddLineItemsClient> addLineItemsClient;

    protected final Supplier<RemoveLineItemsClient> removeLineItemsClient;

    public CourierPayDriverLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCourierPayDriverLineItemGroupsClient(clientOptions);
        this.addLineItemsClient = Suppliers.memoize(() -> new AddLineItemsClient(clientOptions));
        this.removeLineItemsClient = Suppliers.memoize(() -> new RemoveLineItemsClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCourierPayDriverLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a courier driver line item group by its ID. | () -&gt; (CourierPayDriverLineItemGroup1)
     */
    public CourierPayDriverLineItemGroup1 getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).body();
    }

    /**
     * Retrieves a courier driver line item group by its ID. | () -&gt; (CourierPayDriverLineItemGroup1)
     */
    public CourierPayDriverLineItemGroup1 getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).body();
    }

    /**
     * Retrieves a courier driver line item group by its associated task group ID. | () -&gt; (CourierPayDriverLineItemGroup1)
     */
    public CourierPayDriverLineItemGroup1 byTaskGroupIdV1(String taskGroupId) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId).body();
    }

    /**
     * Retrieves a courier driver line item group by its associated task group ID. | () -&gt; (CourierPayDriverLineItemGroup1)
     */
    public CourierPayDriverLineItemGroup1 byTaskGroupIdV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId, requestOptions).body();
    }

    /**
     * Previews calculated line items for a driver based on a rate sheet and task group. Does not write to the database. | (CourierPayDriverLineItemGroupCreateReq) -&gt; (CourierPayDriverLineItemGroupServerCreate1)
     */
    public CourierPayDriverLineItemGroupServerCreate1 previewV1(
            String driverId, CourierPayDriverLineItemGroupCreateReq request) {
        return this.rawClient.previewV1(driverId, request).body();
    }

    /**
     * Previews calculated line items for a driver based on a rate sheet and task group. Does not write to the database. | (CourierPayDriverLineItemGroupCreateReq) -&gt; (CourierPayDriverLineItemGroupServerCreate1)
     */
    public CourierPayDriverLineItemGroupServerCreate1 previewV1(
            String driverId, CourierPayDriverLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(driverId, request, requestOptions).body();
    }

    /**
     * Creates a courier pay driver line item group by calculating items from a rate sheet and task group. | (CourierPayDriverLineItemGroupCreateReq) -&gt; (PydanticObjectId)
     */
    public String createV1(CourierPayDriverLineItemGroupCreateReq request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates a courier pay driver line item group by calculating items from a rate sheet and task group. | (CourierPayDriverLineItemGroupCreateReq) -&gt; (PydanticObjectId)
     */
    public String createV1(CourierPayDriverLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    public AddLineItemsClient addLineItems() {
        return this.addLineItemsClient.get();
    }

    public RemoveLineItemsClient removeLineItems() {
        return this.removeLineItemsClient.get();
    }
}
