/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.courierpaydriverlineitemgroups.removelineitems;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.courierpaydriverlineitemgroups.removelineitems.requests.CourierPayDriverLineItemGroupRemoveLineItemsReq;
import com.chrt.api.types.CourierPayDriverLineItemGroup1;
import com.chrt.api.types.HttpValidationError;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawRemoveLineItemsClient {
    protected final ClientOptions clientOptions;

    public RawRemoveLineItemsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Removes specific line items from a courier driver line item group by their UUID identifiers. | (CourierPayDriverLineItemGroupRemoveLineItemsReq) -&gt; (CourierPayDriverLineItemGroup1)
     */
    public ChrtApiHttpResponse<CourierPayDriverLineItemGroup1> byIdV1(
            String id, CourierPayDriverLineItemGroupRemoveLineItemsReq request) {
        return byIdV1(id, request, null);
    }

    /**
     * Removes specific line items from a courier driver line item group by their UUID identifiers. | (CourierPayDriverLineItemGroupRemoveLineItemsReq) -&gt; (CourierPayDriverLineItemGroup1)
     */
    public ChrtApiHttpResponse<CourierPayDriverLineItemGroup1> byIdV1(
            String id, CourierPayDriverLineItemGroupRemoveLineItemsReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/courier_pay_driver_line_item_groups/remove_line_items/v1")
                .addPathSegment(id)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PATCH", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CourierPayDriverLineItemGroup1.class),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
