/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.courierpaydriverratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoTypeEnum1;
import com.chrt.api.types.RouteTypeEnum1;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CourierPayDriverRateSheetClientCreate1.Builder.class)
public final class CourierPayDriverRateSheetClientCreate1 {
    private final int schemaVersion;

    private final Optional<String> name;

    private final Optional<List<CargoTypeEnum1>> cargoTypes;

    private final Optional<List<VehicleTypeEnum>> vehicleTypes;

    private final Optional<List<RouteTypeEnum1>> routeTypes;

    private final Optional<List<String>> driverIds;

    private final String courierOrgId;

    private final Optional<String> comments;

    private final double baseMileageDistanceMiles;

    private final double baseMileageRateUsdPerInstance;

    private final double additionalMileageRateUsdPerMile;

    private final double longDistanceSurchargeMilesBeforeSurcharge;

    private final double longDistanceSurchargeRateUsdPerMile;

    private final double fuelSurchargeRateUsdPerMile;

    private final double waitTimeBeforeChargeMinutes;

    private final double waitTimeRateUsdPerMinute;

    private final double extraStopRateUsd;

    private final double dangerousGoodsRateUsdPerInstance;

    private final double afterHours;

    private final double weekend;

    private final double holiday;

    private final Map<String, Object> additionalProperties;

    private CourierPayDriverRateSheetClientCreate1(
            int schemaVersion,
            Optional<String> name,
            Optional<List<CargoTypeEnum1>> cargoTypes,
            Optional<List<VehicleTypeEnum>> vehicleTypes,
            Optional<List<RouteTypeEnum1>> routeTypes,
            Optional<List<String>> driverIds,
            String courierOrgId,
            Optional<String> comments,
            double baseMileageDistanceMiles,
            double baseMileageRateUsdPerInstance,
            double additionalMileageRateUsdPerMile,
            double longDistanceSurchargeMilesBeforeSurcharge,
            double longDistanceSurchargeRateUsdPerMile,
            double fuelSurchargeRateUsdPerMile,
            double waitTimeBeforeChargeMinutes,
            double waitTimeRateUsdPerMinute,
            double extraStopRateUsd,
            double dangerousGoodsRateUsdPerInstance,
            double afterHours,
            double weekend,
            double holiday,
            Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.name = name;
        this.cargoTypes = cargoTypes;
        this.vehicleTypes = vehicleTypes;
        this.routeTypes = routeTypes;
        this.driverIds = driverIds;
        this.courierOrgId = courierOrgId;
        this.comments = comments;
        this.baseMileageDistanceMiles = baseMileageDistanceMiles;
        this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
        this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
        this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
        this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
        this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
        this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
        this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
        this.extraStopRateUsd = extraStopRateUsd;
        this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
        this.afterHours = afterHours;
        this.weekend = weekend;
        this.holiday = holiday;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (name == null) {
            return Optional.empty();
        }
        return name;
    }

    @JsonIgnore
    public Optional<List<CargoTypeEnum1>> getCargoTypes() {
        if (cargoTypes == null) {
            return Optional.empty();
        }
        return cargoTypes;
    }

    @JsonIgnore
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        if (vehicleTypes == null) {
            return Optional.empty();
        }
        return vehicleTypes;
    }

    @JsonIgnore
    public Optional<List<RouteTypeEnum1>> getRouteTypes() {
        if (routeTypes == null) {
            return Optional.empty();
        }
        return routeTypes;
    }

    @JsonIgnore
    public Optional<List<String>> getDriverIds() {
        if (driverIds == null) {
            return Optional.empty();
        }
        return driverIds;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonProperty("courier_org_id")
    public String getCourierOrgId() {
        return courierOrgId;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonProperty("base_mileage_distance_miles")
    public double getBaseMileageDistanceMiles() {
        return baseMileageDistanceMiles;
    }

    @JsonProperty("base_mileage_rate_usd_per_instance")
    public double getBaseMileageRateUsdPerInstance() {
        return baseMileageRateUsdPerInstance;
    }

    /**
     * @return applies only to the additional miles
     */
    @JsonProperty("additional_mileage_rate_usd_per_mile")
    public double getAdditionalMileageRateUsdPerMile() {
        return additionalMileageRateUsdPerMile;
    }

    @JsonProperty("long_distance_surcharge_miles_before_surcharge")
    public double getLongDistanceSurchargeMilesBeforeSurcharge() {
        return longDistanceSurchargeMilesBeforeSurcharge;
    }

    /**
     * @return applies only to the additional miles
     */
    @JsonProperty("long_distance_surcharge_rate_usd_per_mile")
    public double getLongDistanceSurchargeRateUsdPerMile() {
        return longDistanceSurchargeRateUsdPerMile;
    }

    @JsonProperty("fuel_surcharge_rate_usd_per_mile")
    public double getFuelSurchargeRateUsdPerMile() {
        return fuelSurchargeRateUsdPerMile;
    }

    @JsonProperty("wait_time_before_charge_minutes")
    public double getWaitTimeBeforeChargeMinutes() {
        return waitTimeBeforeChargeMinutes;
    }

    @JsonProperty("wait_time_rate_usd_per_minute")
    public double getWaitTimeRateUsdPerMinute() {
        return waitTimeRateUsdPerMinute;
    }

    @JsonProperty("extra_stop_rate_usd")
    public double getExtraStopRateUsd() {
        return extraStopRateUsd;
    }

    @JsonProperty("dangerous_goods_rate_usd_per_instance")
    public double getDangerousGoodsRateUsdPerInstance() {
        return dangerousGoodsRateUsdPerInstance;
    }

    @JsonProperty("after_hours")
    public double getAfterHours() {
        return afterHours;
    }

    @JsonProperty("weekend")
    public double getWeekend() {
        return weekend;
    }

    @JsonProperty("holiday")
    public double getHoliday() {
        return holiday;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("name")
    private Optional<String> _getName() {
        return name;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargo_types")
    private Optional<List<CargoTypeEnum1>> _getCargoTypes() {
        return cargoTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("vehicle_types")
    private Optional<List<VehicleTypeEnum>> _getVehicleTypes() {
        return vehicleTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("route_types")
    private Optional<List<RouteTypeEnum1>> _getRouteTypes() {
        return routeTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("driver_ids")
    private Optional<List<String>> _getDriverIds() {
        return driverIds;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CourierPayDriverRateSheetClientCreate1
                && equalTo((CourierPayDriverRateSheetClientCreate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverRateSheetClientCreate1 other) {
        return schemaVersion == other.schemaVersion
                && name.equals(other.name)
                && cargoTypes.equals(other.cargoTypes)
                && vehicleTypes.equals(other.vehicleTypes)
                && routeTypes.equals(other.routeTypes)
                && driverIds.equals(other.driverIds)
                && courierOrgId.equals(other.courierOrgId)
                && comments.equals(other.comments)
                && baseMileageDistanceMiles == other.baseMileageDistanceMiles
                && baseMileageRateUsdPerInstance == other.baseMileageRateUsdPerInstance
                && additionalMileageRateUsdPerMile == other.additionalMileageRateUsdPerMile
                && longDistanceSurchargeMilesBeforeSurcharge == other.longDistanceSurchargeMilesBeforeSurcharge
                && longDistanceSurchargeRateUsdPerMile == other.longDistanceSurchargeRateUsdPerMile
                && fuelSurchargeRateUsdPerMile == other.fuelSurchargeRateUsdPerMile
                && waitTimeBeforeChargeMinutes == other.waitTimeBeforeChargeMinutes
                && waitTimeRateUsdPerMinute == other.waitTimeRateUsdPerMinute
                && extraStopRateUsd == other.extraStopRateUsd
                && dangerousGoodsRateUsdPerInstance == other.dangerousGoodsRateUsdPerInstance
                && afterHours == other.afterHours
                && weekend == other.weekend
                && holiday == other.holiday;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.schemaVersion,
                this.name,
                this.cargoTypes,
                this.vehicleTypes,
                this.routeTypes,
                this.driverIds,
                this.courierOrgId,
                this.comments,
                this.baseMileageDistanceMiles,
                this.baseMileageRateUsdPerInstance,
                this.additionalMileageRateUsdPerMile,
                this.longDistanceSurchargeMilesBeforeSurcharge,
                this.longDistanceSurchargeRateUsdPerMile,
                this.fuelSurchargeRateUsdPerMile,
                this.waitTimeBeforeChargeMinutes,
                this.waitTimeRateUsdPerMinute,
                this.extraStopRateUsd,
                this.dangerousGoodsRateUsdPerInstance,
                this.afterHours,
                this.weekend,
                this.holiday);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        CourierOrgIdStage schemaVersion(int schemaVersion);

        Builder from(CourierPayDriverRateSheetClientCreate1 other);
    }

    public interface CourierOrgIdStage {
        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        BaseMileageDistanceMilesStage courierOrgId(@NotNull String courierOrgId);
    }

    public interface BaseMileageDistanceMilesStage {
        BaseMileageRateUsdPerInstanceStage baseMileageDistanceMiles(double baseMileageDistanceMiles);
    }

    public interface BaseMileageRateUsdPerInstanceStage {
        AdditionalMileageRateUsdPerMileStage baseMileageRateUsdPerInstance(double baseMileageRateUsdPerInstance);
    }

    public interface AdditionalMileageRateUsdPerMileStage {
        /**
         * <p>applies only to the additional miles</p>
         */
        LongDistanceSurchargeMilesBeforeSurchargeStage additionalMileageRateUsdPerMile(
                double additionalMileageRateUsdPerMile);
    }

    public interface LongDistanceSurchargeMilesBeforeSurchargeStage {
        LongDistanceSurchargeRateUsdPerMileStage longDistanceSurchargeMilesBeforeSurcharge(
                double longDistanceSurchargeMilesBeforeSurcharge);
    }

    public interface LongDistanceSurchargeRateUsdPerMileStage {
        /**
         * <p>applies only to the additional miles</p>
         */
        FuelSurchargeRateUsdPerMileStage longDistanceSurchargeRateUsdPerMile(
                double longDistanceSurchargeRateUsdPerMile);
    }

    public interface FuelSurchargeRateUsdPerMileStage {
        WaitTimeBeforeChargeMinutesStage fuelSurchargeRateUsdPerMile(double fuelSurchargeRateUsdPerMile);
    }

    public interface WaitTimeBeforeChargeMinutesStage {
        WaitTimeRateUsdPerMinuteStage waitTimeBeforeChargeMinutes(double waitTimeBeforeChargeMinutes);
    }

    public interface WaitTimeRateUsdPerMinuteStage {
        ExtraStopRateUsdStage waitTimeRateUsdPerMinute(double waitTimeRateUsdPerMinute);
    }

    public interface ExtraStopRateUsdStage {
        DangerousGoodsRateUsdPerInstanceStage extraStopRateUsd(double extraStopRateUsd);
    }

    public interface DangerousGoodsRateUsdPerInstanceStage {
        AfterHoursStage dangerousGoodsRateUsdPerInstance(double dangerousGoodsRateUsdPerInstance);
    }

    public interface AfterHoursStage {
        WeekendStage afterHours(double afterHours);
    }

    public interface WeekendStage {
        HolidayStage weekend(double weekend);
    }

    public interface HolidayStage {
        _FinalStage holiday(double holiday);
    }

    public interface _FinalStage {
        CourierPayDriverRateSheetClientCreate1 build();

        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        _FinalStage name(Nullable<String> name);

        _FinalStage cargoTypes(Optional<List<CargoTypeEnum1>> cargoTypes);

        _FinalStage cargoTypes(List<CargoTypeEnum1> cargoTypes);

        _FinalStage cargoTypes(Nullable<List<CargoTypeEnum1>> cargoTypes);

        _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes);

        _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes);

        _FinalStage vehicleTypes(Nullable<List<VehicleTypeEnum>> vehicleTypes);

        _FinalStage routeTypes(Optional<List<RouteTypeEnum1>> routeTypes);

        _FinalStage routeTypes(List<RouteTypeEnum1> routeTypes);

        _FinalStage routeTypes(Nullable<List<RouteTypeEnum1>> routeTypes);

        _FinalStage driverIds(Optional<List<String>> driverIds);

        _FinalStage driverIds(List<String> driverIds);

        _FinalStage driverIds(Nullable<List<String>> driverIds);

        _FinalStage comments(Optional<String> comments);

        _FinalStage comments(String comments);

        _FinalStage comments(Nullable<String> comments);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements SchemaVersionStage,
                    CourierOrgIdStage,
                    BaseMileageDistanceMilesStage,
                    BaseMileageRateUsdPerInstanceStage,
                    AdditionalMileageRateUsdPerMileStage,
                    LongDistanceSurchargeMilesBeforeSurchargeStage,
                    LongDistanceSurchargeRateUsdPerMileStage,
                    FuelSurchargeRateUsdPerMileStage,
                    WaitTimeBeforeChargeMinutesStage,
                    WaitTimeRateUsdPerMinuteStage,
                    ExtraStopRateUsdStage,
                    DangerousGoodsRateUsdPerInstanceStage,
                    AfterHoursStage,
                    WeekendStage,
                    HolidayStage,
                    _FinalStage {
        private int schemaVersion;

        private String courierOrgId;

        private double baseMileageDistanceMiles;

        private double baseMileageRateUsdPerInstance;

        private double additionalMileageRateUsdPerMile;

        private double longDistanceSurchargeMilesBeforeSurcharge;

        private double longDistanceSurchargeRateUsdPerMile;

        private double fuelSurchargeRateUsdPerMile;

        private double waitTimeBeforeChargeMinutes;

        private double waitTimeRateUsdPerMinute;

        private double extraStopRateUsd;

        private double dangerousGoodsRateUsdPerInstance;

        private double afterHours;

        private double weekend;

        private double holiday;

        private Optional<String> comments = Optional.empty();

        private Optional<List<String>> driverIds = Optional.empty();

        private Optional<List<RouteTypeEnum1>> routeTypes = Optional.empty();

        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();

        private Optional<List<CargoTypeEnum1>> cargoTypes = Optional.empty();

        private Optional<String> name = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CourierPayDriverRateSheetClientCreate1 other) {
            schemaVersion(other.getSchemaVersion());
            name(other.getName());
            cargoTypes(other.getCargoTypes());
            vehicleTypes(other.getVehicleTypes());
            routeTypes(other.getRouteTypes());
            driverIds(other.getDriverIds());
            courierOrgId(other.getCourierOrgId());
            comments(other.getComments());
            baseMileageDistanceMiles(other.getBaseMileageDistanceMiles());
            baseMileageRateUsdPerInstance(other.getBaseMileageRateUsdPerInstance());
            additionalMileageRateUsdPerMile(other.getAdditionalMileageRateUsdPerMile());
            longDistanceSurchargeMilesBeforeSurcharge(other.getLongDistanceSurchargeMilesBeforeSurcharge());
            longDistanceSurchargeRateUsdPerMile(other.getLongDistanceSurchargeRateUsdPerMile());
            fuelSurchargeRateUsdPerMile(other.getFuelSurchargeRateUsdPerMile());
            waitTimeBeforeChargeMinutes(other.getWaitTimeBeforeChargeMinutes());
            waitTimeRateUsdPerMinute(other.getWaitTimeRateUsdPerMinute());
            extraStopRateUsd(other.getExtraStopRateUsd());
            dangerousGoodsRateUsdPerInstance(other.getDangerousGoodsRateUsdPerInstance());
            afterHours(other.getAfterHours());
            weekend(other.getWeekend());
            holiday(other.getHoliday());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public CourierOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         * <p>Must be a string starting with <code>org_</code></p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("courier_org_id")
        public BaseMileageDistanceMilesStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("base_mileage_distance_miles")
        public BaseMileageRateUsdPerInstanceStage baseMileageDistanceMiles(double baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = baseMileageDistanceMiles;
            return this;
        }

        @java.lang.Override
        @JsonSetter("base_mileage_rate_usd_per_instance")
        public AdditionalMileageRateUsdPerMileStage baseMileageRateUsdPerInstance(
                double baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
            return this;
        }

        /**
         * <p>applies only to the additional miles</p>
         * <p>applies only to the additional miles</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("additional_mileage_rate_usd_per_mile")
        public LongDistanceSurchargeMilesBeforeSurchargeStage additionalMileageRateUsdPerMile(
                double additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
            return this;
        }

        @java.lang.Override
        @JsonSetter("long_distance_surcharge_miles_before_surcharge")
        public LongDistanceSurchargeRateUsdPerMileStage longDistanceSurchargeMilesBeforeSurcharge(
                double longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
            return this;
        }

        /**
         * <p>applies only to the additional miles</p>
         * <p>applies only to the additional miles</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("long_distance_surcharge_rate_usd_per_mile")
        public FuelSurchargeRateUsdPerMileStage longDistanceSurchargeRateUsdPerMile(
                double longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
            return this;
        }

        @java.lang.Override
        @JsonSetter("fuel_surcharge_rate_usd_per_mile")
        public WaitTimeBeforeChargeMinutesStage fuelSurchargeRateUsdPerMile(double fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
            return this;
        }

        @java.lang.Override
        @JsonSetter("wait_time_before_charge_minutes")
        public WaitTimeRateUsdPerMinuteStage waitTimeBeforeChargeMinutes(double waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
            return this;
        }

        @java.lang.Override
        @JsonSetter("wait_time_rate_usd_per_minute")
        public ExtraStopRateUsdStage waitTimeRateUsdPerMinute(double waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
            return this;
        }

        @java.lang.Override
        @JsonSetter("extra_stop_rate_usd")
        public DangerousGoodsRateUsdPerInstanceStage extraStopRateUsd(double extraStopRateUsd) {
            this.extraStopRateUsd = extraStopRateUsd;
            return this;
        }

        @java.lang.Override
        @JsonSetter("dangerous_goods_rate_usd_per_instance")
        public AfterHoursStage dangerousGoodsRateUsdPerInstance(double dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
            return this;
        }

        @java.lang.Override
        @JsonSetter("after_hours")
        public WeekendStage afterHours(double afterHours) {
            this.afterHours = afterHours;
            return this;
        }

        @java.lang.Override
        @JsonSetter("weekend")
        public HolidayStage weekend(double weekend) {
            this.weekend = weekend;
            return this;
        }

        @java.lang.Override
        @JsonSetter("holiday")
        public _FinalStage holiday(double holiday) {
            this.holiday = holiday;
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @java.lang.Override
        public _FinalStage driverIds(Nullable<List<String>> driverIds) {
            if (driverIds.isNull()) {
                this.driverIds = null;
            } else if (driverIds.isEmpty()) {
                this.driverIds = Optional.empty();
            } else {
                this.driverIds = Optional.of(driverIds.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage driverIds(List<String> driverIds) {
            this.driverIds = Optional.ofNullable(driverIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "driver_ids", nulls = Nulls.SKIP)
        public _FinalStage driverIds(Optional<List<String>> driverIds) {
            this.driverIds = driverIds;
            return this;
        }

        @java.lang.Override
        public _FinalStage routeTypes(Nullable<List<RouteTypeEnum1>> routeTypes) {
            if (routeTypes.isNull()) {
                this.routeTypes = null;
            } else if (routeTypes.isEmpty()) {
                this.routeTypes = Optional.empty();
            } else {
                this.routeTypes = Optional.of(routeTypes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage routeTypes(List<RouteTypeEnum1> routeTypes) {
            this.routeTypes = Optional.ofNullable(routeTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "route_types", nulls = Nulls.SKIP)
        public _FinalStage routeTypes(Optional<List<RouteTypeEnum1>> routeTypes) {
            this.routeTypes = routeTypes;
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(Nullable<List<VehicleTypeEnum>> vehicleTypes) {
            if (vehicleTypes.isNull()) {
                this.vehicleTypes = null;
            } else if (vehicleTypes.isEmpty()) {
                this.vehicleTypes = Optional.empty();
            } else {
                this.vehicleTypes = Optional.of(vehicleTypes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "vehicle_types", nulls = Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @java.lang.Override
        public _FinalStage cargoTypes(Nullable<List<CargoTypeEnum1>> cargoTypes) {
            if (cargoTypes.isNull()) {
                this.cargoTypes = null;
            } else if (cargoTypes.isEmpty()) {
                this.cargoTypes = Optional.empty();
            } else {
                this.cargoTypes = Optional.of(cargoTypes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage cargoTypes(List<CargoTypeEnum1> cargoTypes) {
            this.cargoTypes = Optional.ofNullable(cargoTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cargo_types", nulls = Nulls.SKIP)
        public _FinalStage cargoTypes(Optional<List<CargoTypeEnum1>> cargoTypes) {
            this.cargoTypes = cargoTypes;
            return this;
        }

        @java.lang.Override
        public _FinalStage name(Nullable<String> name) {
            if (name.isNull()) {
                this.name = null;
            } else if (name.isEmpty()) {
                this.name = Optional.empty();
            } else {
                this.name = Optional.of(name.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @java.lang.Override
        public CourierPayDriverRateSheetClientCreate1 build() {
            return new CourierPayDriverRateSheetClientCreate1(
                    schemaVersion,
                    name,
                    cargoTypes,
                    vehicleTypes,
                    routeTypes,
                    driverIds,
                    courierOrgId,
                    comments,
                    baseMileageDistanceMiles,
                    baseMileageRateUsdPerInstance,
                    additionalMileageRateUsdPerMile,
                    longDistanceSurchargeMilesBeforeSurcharge,
                    longDistanceSurchargeRateUsdPerMile,
                    fuelSurchargeRateUsdPerMile,
                    waitTimeBeforeChargeMinutes,
                    waitTimeRateUsdPerMinute,
                    extraStopRateUsd,
                    dangerousGoodsRateUsdPerInstance,
                    afterHours,
                    weekend,
                    holiday,
                    additionalProperties);
        }
    }
}
