/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.dev;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.dev.requests.TemplateReq;
import com.chrt.api.types.DecodedJwtWithOrgAndUserId;
import com.chrt.api.types.TemplateRes;
import java.util.Map;

public class DevClient {
    protected final ClientOptions clientOptions;

    private final RawDevClient rawClient;

    public DevClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDevClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawDevClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Experimental endpoint for running AI agentic workflows. Returns the caller's ID for testing purposes. | () -&gt; (str)
     */
    public String getAgentV1() {
        return this.rawClient.getAgentV1().body();
    }

    /**
     * Experimental endpoint for running AI agentic workflows. Returns the caller's ID for testing purposes. | () -&gt; (str)
     */
    public String getAgentV1(RequestOptions requestOptions) {
        return this.rawClient.getAgentV1(requestOptions).body();
    }

    /**
     * (DEPRECATED) Extracts and returns the user ID from the authenticated request's JWT token. | () -&gt; (str)
     */
    public String getUserIdV1() {
        return this.rawClient.getUserIdV1().body();
    }

    /**
     * (DEPRECATED) Extracts and returns the user ID from the authenticated request's JWT token. | () -&gt; (str)
     */
    public String getUserIdV1(RequestOptions requestOptions) {
        return this.rawClient.getUserIdV1(requestOptions).body();
    }

    /**
     * Extracts and returns the user ID from the authenticated request's JWT token. | () -&gt; (str)
     */
    public String getUserIdV2() {
        return this.rawClient.getUserIdV2().body();
    }

    /**
     * Extracts and returns the user ID from the authenticated request's JWT token. | () -&gt; (str)
     */
    public String getUserIdV2(RequestOptions requestOptions) {
        return this.rawClient.getUserIdV2(requestOptions).body();
    }

    /**
     * Returns the complete decoded JWT token information for development purposes. | () -&gt; (DecodedJWTWithOrgAndUserId)
     */
    public DecodedJwtWithOrgAndUserId getDecodedJwtV1() {
        return this.rawClient.getDecodedJwtV1().body();
    }

    /**
     * Returns the complete decoded JWT token information for development purposes. | () -&gt; (DecodedJWTWithOrgAndUserId)
     */
    public DecodedJwtWithOrgAndUserId getDecodedJwtV1(RequestOptions requestOptions) {
        return this.rawClient.getDecodedJwtV1(requestOptions).body();
    }

    /**
     * Retrieves the primary email address for the caller from the authentication service. | () -&gt; (str)
     */
    public String getEmailV1() {
        return this.rawClient.getEmailV1().body();
    }

    /**
     * Retrieves the primary email address for the caller from the authentication service. | () -&gt; (str)
     */
    public String getEmailV1(RequestOptions requestOptions) {
        return this.rawClient.getEmailV1(requestOptions).body();
    }

    /**
     * Experimental endpoint for running durable execution workflows. Returns the caller's ID for testing purposes. | () -&gt; (dict[str, Any])
     */
    public Map<String, Object> getDurableV1() {
        return this.rawClient.getDurableV1().body();
    }

    /**
     * Experimental endpoint for running durable execution workflows. Returns the caller's ID for testing purposes. | () -&gt; (dict[str, Any])
     */
    public Map<String, Object> getDurableV1(RequestOptions requestOptions) {
        return this.rawClient.getDurableV1(requestOptions).body();
    }

    /**
     * Development template endpoint that returns the caller's ID for testing. | () -&gt; (str)
     */
    public String getTemplateV1() {
        return this.rawClient.getTemplateV1().body();
    }

    /**
     * Development template endpoint that returns the caller's ID for testing. | () -&gt; (str)
     */
    public String getTemplateV1(RequestOptions requestOptions) {
        return this.rawClient.getTemplateV1(requestOptions).body();
    }

    /**
     * Development template endpoint that demonstrates transaction handling and request mirroring. | (TemplateReq) -&gt; (TemplateRes)
     */
    public TemplateRes createTemplateV1(TemplateReq request) {
        return this.rawClient.createTemplateV1(request).body();
    }

    /**
     * Development template endpoint that demonstrates transaction handling and request mirroring. | (TemplateReq) -&gt; (TemplateRes)
     */
    public TemplateRes createTemplateV1(TemplateReq request, RequestOptions requestOptions) {
        return this.rawClient.createTemplateV1(request, requestOptions).body();
    }

    /**
     * Returns the current GitHub PR number and commit hash for the deployment. | () -&gt; (dict[str, str])
     */
    public Map<String, String> getGitInfoV1() {
        return this.rawClient.getGitInfoV1().body();
    }

    /**
     * Returns the current GitHub PR number and commit hash for the deployment. | () -&gt; (dict[str, str])
     */
    public Map<String, String> getGitInfoV1(RequestOptions requestOptions) {
        return this.rawClient.getGitInfoV1(requestOptions).body();
    }
}
