/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.drivers;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.drivers.requests.DriverClientCreate1;
import com.chrt.api.resources.drivers.requests.DriverClientUpdate1;
import com.chrt.api.resources.drivers.requests.DriverLastSeenReq;
import com.chrt.api.resources.drivers.requests.DriversListOrgMembersAndDriversV1Request;
import com.chrt.api.resources.drivers.requests.DriversListV1Request;
import com.chrt.api.types.Driver1;
import com.chrt.api.types.DriverUpdateAvailabilityReq;
import com.chrt.api.types.OrgMembersAndDrivers;
import java.util.List;

public class DriversClient {
    protected final ClientOptions clientOptions;

    private final RawDriversClient rawClient;

    public DriversClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDriversClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawDriversClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves driver information for the caller within their organization. | () -&gt; (Driver1)
     */
    public Driver1 getForCallerV1() {
        return this.rawClient.getForCallerV1().body();
    }

    /**
     * Retrieves driver information for the caller within their organization. | () -&gt; (Driver1)
     */
    public Driver1 getForCallerV1(RequestOptions requestOptions) {
        return this.rawClient.getForCallerV1(requestOptions).body();
    }

    /**
     * Retrieves detailed driver information by driver ID within the organization. | () -&gt; (Driver1)
     */
    public Driver1 getByDriverIdV1(String driverId) {
        return this.rawClient.getByDriverIdV1(driverId).body();
    }

    /**
     * Retrieves detailed driver information by driver ID within the organization. | () -&gt; (Driver1)
     */
    public Driver1 getByDriverIdV1(String driverId, RequestOptions requestOptions) {
        return this.rawClient.getByDriverIdV1(driverId, requestOptions).body();
    }

    /**
     * Lists all organization members paired with their driver information if they are drivers. Filter by availability. | () -&gt; (list[OrgMembersAndDrivers])
     */
    public List<OrgMembersAndDrivers> listOrgMembersAndDriversV1() {
        return this.rawClient.listOrgMembersAndDriversV1().body();
    }

    /**
     * Lists all organization members paired with their driver information if they are drivers. Filter by availability. | () -&gt; (list[OrgMembersAndDrivers])
     */
    public List<OrgMembersAndDrivers> listOrgMembersAndDriversV1(DriversListOrgMembersAndDriversV1Request request) {
        return this.rawClient.listOrgMembersAndDriversV1(request).body();
    }

    /**
     * Lists all organization members paired with their driver information if they are drivers. Filter by availability. | () -&gt; (list[OrgMembersAndDrivers])
     */
    public List<OrgMembersAndDrivers> listOrgMembersAndDriversV1(
            DriversListOrgMembersAndDriversV1Request request, RequestOptions requestOptions) {
        return this.rawClient
                .listOrgMembersAndDriversV1(request, requestOptions)
                .body();
    }

    /**
     * Lists all drivers belonging to the caller's organization. Filter by availability. | () -&gt; (list[Driver1])
     */
    public List<Driver1> listV1() {
        return this.rawClient.listV1().body();
    }

    /**
     * Lists all drivers belonging to the caller's organization. Filter by availability. | () -&gt; (list[Driver1])
     */
    public List<Driver1> listV1(DriversListV1Request request) {
        return this.rawClient.listV1(request).body();
    }

    /**
     * Lists all drivers belonging to the caller's organization. Filter by availability. | () -&gt; (list[Driver1])
     */
    public List<Driver1> listV1(DriversListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.listV1(request, requestOptions).body();
    }

    /**
     * Creates a new driver profile for the target user (defaults to caller). Drivers can create themselves; operators+ can create any org member. Courier orgs only. | (DriverClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(DriverClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates a new driver profile for the target user (defaults to caller). Drivers can create themselves; operators+ can create any org member. Courier orgs only. | (DriverClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(DriverClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Updates driver contact details and vehicle type assignments. Courier orgs only; caller must be the driver (self) or an operator+. | (DriverClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(String driverId) {
        return this.rawClient.updateV1(driverId).body();
    }

    /**
     * Updates driver contact details and vehicle type assignments. Courier orgs only; caller must be the driver (self) or an operator+. | (DriverClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(String driverId, DriverClientUpdate1 request) {
        return this.rawClient.updateV1(driverId, request).body();
    }

    /**
     * Updates driver contact details and vehicle type assignments. Courier orgs only; caller must be the driver (self) or an operator+. | (DriverClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(String driverId, DriverClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(driverId, request, requestOptions).body();
    }

    /**
     * Updates the caller's driver last known location and timestamp for tracking. Only updates if timestamp is newer than existing (DB-side validation). Returns False if driver not found or timestamp is stale. | (DriverLastSeenReq) -&gt; (bool)
     */
    public boolean updateLastSeenV1(DriverLastSeenReq request) {
        return this.rawClient.updateLastSeenV1(request).body();
    }

    /**
     * Updates the caller's driver last known location and timestamp for tracking. Only updates if timestamp is newer than existing (DB-side validation). Returns False if driver not found or timestamp is stale. | (DriverLastSeenReq) -&gt; (bool)
     */
    public boolean updateLastSeenV1(DriverLastSeenReq request, RequestOptions requestOptions) {
        return this.rawClient.updateLastSeenV1(request, requestOptions).body();
    }

    /**
     * Clears the driver's last known location and timestamp. | () -&gt; (bool)
     */
    public boolean clearLastSeenV1() {
        return this.rawClient.clearLastSeenV1().body();
    }

    /**
     * Clears the driver's last known location and timestamp. | () -&gt; (bool)
     */
    public boolean clearLastSeenV1(RequestOptions requestOptions) {
        return this.rawClient.clearLastSeenV1(requestOptions).body();
    }

    /**
     * Updates the caller's driver availability status. Must have status UNASSIGNED to set availability to False; always allows setting to True. Courier orgs only. | (DriverUpdateAvailabilityReq) -&gt; (bool)
     */
    public boolean updateAvailabilityAccordingToDriverV1(DriverUpdateAvailabilityReq request) {
        return this.rawClient.updateAvailabilityAccordingToDriverV1(request).body();
    }

    /**
     * Updates the caller's driver availability status. Must have status UNASSIGNED to set availability to False; always allows setting to True. Courier orgs only. | (DriverUpdateAvailabilityReq) -&gt; (bool)
     */
    public boolean updateAvailabilityAccordingToDriverV1(
            DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateAvailabilityAccordingToDriverV1(request, requestOptions)
                .body();
    }

    /**
     * Updates a driver's availability status. Must have status UNASSIGNED to set availability to False; always allows setting to True. Courier orgs only, min role: operator. | (DriverUpdateAvailabilityReq) -&gt; (bool)
     */
    public boolean updateAvailabilityAccordingToOperatorsV1(String driverId, DriverUpdateAvailabilityReq request) {
        return this.rawClient
                .updateAvailabilityAccordingToOperatorsV1(driverId, request)
                .body();
    }

    /**
     * Updates a driver's availability status. Must have status UNASSIGNED to set availability to False; always allows setting to True. Courier orgs only, min role: operator. | (DriverUpdateAvailabilityReq) -&gt; (bool)
     */
    public boolean updateAvailabilityAccordingToOperatorsV1(
            String driverId, DriverUpdateAvailabilityReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateAvailabilityAccordingToOperatorsV1(driverId, request, requestOptions)
                .body();
    }
}
