/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.drivers.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DriverClientCreate1.Builder.class)
public final class DriverClientCreate1 {
    private final Optional<String> targetUserId;

    private final int schemaVersion;

    private final Optional<String> emailAddressPrimary;

    private final Optional<String> emailAddressSecondary;

    private final Optional<String> phoneNumberPrimary;

    private final Optional<String> phoneNumberSecondary;

    private final Optional<String> firstName;

    private final Optional<String> lastName;

    private final Optional<List<VehicleTypeEnum>> vehicleTypes;

    private final Map<String, Object> additionalProperties;

    private DriverClientCreate1(
            Optional<String> targetUserId,
            int schemaVersion,
            Optional<String> emailAddressPrimary,
            Optional<String> emailAddressSecondary,
            Optional<String> phoneNumberPrimary,
            Optional<String> phoneNumberSecondary,
            Optional<String> firstName,
            Optional<String> lastName,
            Optional<List<VehicleTypeEnum>> vehicleTypes,
            Map<String, Object> additionalProperties) {
        this.targetUserId = targetUserId;
        this.schemaVersion = schemaVersion;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.firstName = firstName;
        this.lastName = lastName;
        this.vehicleTypes = vehicleTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getTargetUserId() {
        if (targetUserId == null) {
            return Optional.empty();
        }
        return targetUserId;
    }

    @JsonProperty("schema_version")
    public int getSchemaVersion() {
        return schemaVersion;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressPrimary() {
        if (emailAddressPrimary == null) {
            return Optional.empty();
        }
        return emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (emailAddressSecondary == null) {
            return Optional.empty();
        }
        return emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return phoneNumberSecondary;
    }

    @JsonIgnore
    public Optional<String> getFirstName() {
        if (firstName == null) {
            return Optional.empty();
        }
        return firstName;
    }

    @JsonIgnore
    public Optional<String> getLastName() {
        if (lastName == null) {
            return Optional.empty();
        }
        return lastName;
    }

    @JsonProperty("vehicle_types")
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        return vehicleTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("target_user_id")
    private Optional<String> _getTargetUserId() {
        return targetUserId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_primary")
    private Optional<String> _getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return emailAddressSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return phoneNumberSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("first_name")
    private Optional<String> _getFirstName() {
        return firstName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("last_name")
    private Optional<String> _getLastName() {
        return lastName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DriverClientCreate1 && equalTo((DriverClientCreate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverClientCreate1 other) {
        return targetUserId.equals(other.targetUserId)
                && schemaVersion == other.schemaVersion
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && emailAddressSecondary.equals(other.emailAddressSecondary)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary)
                && phoneNumberSecondary.equals(other.phoneNumberSecondary)
                && firstName.equals(other.firstName)
                && lastName.equals(other.lastName)
                && vehicleTypes.equals(other.vehicleTypes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.targetUserId,
                this.schemaVersion,
                this.emailAddressPrimary,
                this.emailAddressSecondary,
                this.phoneNumberPrimary,
                this.phoneNumberSecondary,
                this.firstName,
                this.lastName,
                this.vehicleTypes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    public interface SchemaVersionStage {
        _FinalStage schemaVersion(int schemaVersion);

        Builder from(DriverClientCreate1 other);
    }

    public interface _FinalStage {
        DriverClientCreate1 build();

        _FinalStage targetUserId(Optional<String> targetUserId);

        _FinalStage targetUserId(String targetUserId);

        _FinalStage targetUserId(Nullable<String> targetUserId);

        _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary);

        _FinalStage emailAddressPrimary(String emailAddressPrimary);

        _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary);

        _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary);

        _FinalStage emailAddressSecondary(String emailAddressSecondary);

        _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary);

        _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(String phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary);

        _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(String phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary);

        _FinalStage firstName(Optional<String> firstName);

        _FinalStage firstName(String firstName);

        _FinalStage firstName(Nullable<String> firstName);

        _FinalStage lastName(Optional<String> lastName);

        _FinalStage lastName(String lastName);

        _FinalStage lastName(Nullable<String> lastName);

        _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes);

        _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SchemaVersionStage, _FinalStage {
        private int schemaVersion;

        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();

        private Optional<String> lastName = Optional.empty();

        private Optional<String> firstName = Optional.empty();

        private Optional<String> phoneNumberSecondary = Optional.empty();

        private Optional<String> phoneNumberPrimary = Optional.empty();

        private Optional<String> emailAddressSecondary = Optional.empty();

        private Optional<String> emailAddressPrimary = Optional.empty();

        private Optional<String> targetUserId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DriverClientCreate1 other) {
            targetUserId(other.getTargetUserId());
            schemaVersion(other.getSchemaVersion());
            emailAddressPrimary(other.getEmailAddressPrimary());
            emailAddressSecondary(other.getEmailAddressSecondary());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            phoneNumberSecondary(other.getPhoneNumberSecondary());
            firstName(other.getFirstName());
            lastName(other.getLastName());
            vehicleTypes(other.getVehicleTypes());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schema_version")
        public _FinalStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "vehicle_types", nulls = Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @java.lang.Override
        public _FinalStage lastName(Nullable<String> lastName) {
            if (lastName.isNull()) {
                this.lastName = null;
            } else if (lastName.isEmpty()) {
                this.lastName = Optional.empty();
            } else {
                this.lastName = Optional.of(lastName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage lastName(String lastName) {
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "last_name", nulls = Nulls.SKIP)
        public _FinalStage lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        @java.lang.Override
        public _FinalStage firstName(Nullable<String> firstName) {
            if (firstName.isNull()) {
                this.firstName = null;
            } else if (firstName.isEmpty()) {
                this.firstName = Optional.empty();
            } else {
                this.firstName = Optional.of(firstName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage firstName(String firstName) {
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "first_name", nulls = Nulls.SKIP)
        public _FinalStage firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            if (phoneNumberSecondary.isNull()) {
                this.phoneNumberSecondary = null;
            } else if (phoneNumberSecondary.isEmpty()) {
                this.phoneNumberSecondary = Optional.empty();
            } else {
                this.phoneNumberSecondary = Optional.of(phoneNumberSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_secondary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            if (phoneNumberPrimary.isNull()) {
                this.phoneNumberPrimary = null;
            } else if (phoneNumberPrimary.isEmpty()) {
                this.phoneNumberPrimary = Optional.empty();
            } else {
                this.phoneNumberPrimary = Optional.of(phoneNumberPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_primary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            if (emailAddressSecondary.isNull()) {
                this.emailAddressSecondary = null;
            } else if (emailAddressSecondary.isEmpty()) {
                this.emailAddressSecondary = Optional.empty();
            } else {
                this.emailAddressSecondary = Optional.of(emailAddressSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_secondary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary) {
            if (emailAddressPrimary.isNull()) {
                this.emailAddressPrimary = null;
            } else if (emailAddressPrimary.isEmpty()) {
                this.emailAddressPrimary = Optional.empty();
            } else {
                this.emailAddressPrimary = Optional.of(emailAddressPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressPrimary(String emailAddressPrimary) {
            this.emailAddressPrimary = Optional.ofNullable(emailAddressPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_primary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary;
            return this;
        }

        @java.lang.Override
        public _FinalStage targetUserId(Nullable<String> targetUserId) {
            if (targetUserId.isNull()) {
                this.targetUserId = null;
            } else if (targetUserId.isEmpty()) {
                this.targetUserId = Optional.empty();
            } else {
                this.targetUserId = Optional.of(targetUserId.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage targetUserId(String targetUserId) {
            this.targetUserId = Optional.ofNullable(targetUserId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "target_user_id", nulls = Nulls.SKIP)
        public _FinalStage targetUserId(Optional<String> targetUserId) {
            this.targetUserId = targetUserId;
            return this;
        }

        @java.lang.Override
        public DriverClientCreate1 build() {
            return new DriverClientCreate1(
                    targetUserId,
                    schemaVersion,
                    emailAddressPrimary,
                    emailAddressSecondary,
                    phoneNumberPrimary,
                    phoneNumberSecondary,
                    firstName,
                    lastName,
                    vehicleTypes,
                    additionalProperties);
        }
    }
}
