/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.drivers.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DriverLastSeenReq.Builder.class)
public final class DriverLastSeenReq {
    private final LocationFeature location;

    private final Optional<OffsetDateTime> timestamp;

    private final Map<String, Object> additionalProperties;

    private DriverLastSeenReq(
            LocationFeature location, Optional<OffsetDateTime> timestamp, Map<String, Object> additionalProperties) {
        this.location = location;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("location")
    public LocationFeature getLocation() {
        return location;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getTimestamp() {
        if (timestamp == null) {
            return Optional.empty();
        }
        return timestamp;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("timestamp")
    private Optional<OffsetDateTime> _getTimestamp() {
        return timestamp;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DriverLastSeenReq && equalTo((DriverLastSeenReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverLastSeenReq other) {
        return location.equals(other.location) && timestamp.equals(other.timestamp);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.location, this.timestamp);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationStage builder() {
        return new Builder();
    }

    public interface LocationStage {
        _FinalStage location(@NotNull LocationFeature location);

        Builder from(DriverLastSeenReq other);
    }

    public interface _FinalStage {
        DriverLastSeenReq build();

        _FinalStage timestamp(Optional<OffsetDateTime> timestamp);

        _FinalStage timestamp(OffsetDateTime timestamp);

        _FinalStage timestamp(Nullable<OffsetDateTime> timestamp);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements LocationStage, _FinalStage {
        private LocationFeature location;

        private Optional<OffsetDateTime> timestamp = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DriverLastSeenReq other) {
            location(other.getLocation());
            timestamp(other.getTimestamp());
            return this;
        }

        @java.lang.Override
        @JsonSetter("location")
        public _FinalStage location(@NotNull LocationFeature location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage timestamp(Nullable<OffsetDateTime> timestamp) {
            if (timestamp.isNull()) {
                this.timestamp = null;
            } else if (timestamp.isEmpty()) {
                this.timestamp = Optional.empty();
            } else {
                this.timestamp = Optional.of(timestamp.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage timestamp(OffsetDateTime timestamp) {
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "timestamp", nulls = Nulls.SKIP)
        public _FinalStage timestamp(Optional<OffsetDateTime> timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @java.lang.Override
        public DriverLastSeenReq build() {
            return new DriverLastSeenReq(location, timestamp, additionalProperties);
        }
    }
}
