/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.drivers.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DriversListOrgMembersAndDriversV1Request.Builder.class)
public final class DriversListOrgMembersAndDriversV1Request {
    private final Optional<Boolean> availableAccordingToDriver;

    private final Optional<Boolean> availableAccordingToOperators;

    private final Map<String, Object> additionalProperties;

    private DriversListOrgMembersAndDriversV1Request(
            Optional<Boolean> availableAccordingToDriver,
            Optional<Boolean> availableAccordingToOperators,
            Map<String, Object> additionalProperties) {
        this.availableAccordingToDriver = availableAccordingToDriver;
        this.availableAccordingToOperators = availableAccordingToOperators;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Filter by driver's self-reported availability.
     */
    @JsonIgnore
    public Optional<Boolean> getAvailableAccordingToDriver() {
        if (availableAccordingToDriver == null) {
            return Optional.empty();
        }
        return availableAccordingToDriver;
    }

    /**
     * @return Filter by operator-set availability.
     */
    @JsonIgnore
    public Optional<Boolean> getAvailableAccordingToOperators() {
        if (availableAccordingToOperators == null) {
            return Optional.empty();
        }
        return availableAccordingToOperators;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("available_according_to_driver")
    private Optional<Boolean> _getAvailableAccordingToDriver() {
        return availableAccordingToDriver;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("available_according_to_operators")
    private Optional<Boolean> _getAvailableAccordingToOperators() {
        return availableAccordingToOperators;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DriversListOrgMembersAndDriversV1Request
                && equalTo((DriversListOrgMembersAndDriversV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriversListOrgMembersAndDriversV1Request other) {
        return availableAccordingToDriver.equals(other.availableAccordingToDriver)
                && availableAccordingToOperators.equals(other.availableAccordingToOperators);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.availableAccordingToDriver, this.availableAccordingToOperators);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Boolean> availableAccordingToDriver = Optional.empty();

        private Optional<Boolean> availableAccordingToOperators = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DriversListOrgMembersAndDriversV1Request other) {
            availableAccordingToDriver(other.getAvailableAccordingToDriver());
            availableAccordingToOperators(other.getAvailableAccordingToOperators());
            return this;
        }

        /**
         * <p>Filter by driver's self-reported availability.</p>
         */
        @JsonSetter(value = "available_according_to_driver", nulls = Nulls.SKIP)
        public Builder availableAccordingToDriver(Optional<Boolean> availableAccordingToDriver) {
            this.availableAccordingToDriver = availableAccordingToDriver;
            return this;
        }

        public Builder availableAccordingToDriver(Boolean availableAccordingToDriver) {
            this.availableAccordingToDriver = Optional.ofNullable(availableAccordingToDriver);
            return this;
        }

        public Builder availableAccordingToDriver(Nullable<Boolean> availableAccordingToDriver) {
            if (availableAccordingToDriver.isNull()) {
                this.availableAccordingToDriver = null;
            } else if (availableAccordingToDriver.isEmpty()) {
                this.availableAccordingToDriver = Optional.empty();
            } else {
                this.availableAccordingToDriver = Optional.of(availableAccordingToDriver.get());
            }
            return this;
        }

        /**
         * <p>Filter by operator-set availability.</p>
         */
        @JsonSetter(value = "available_according_to_operators", nulls = Nulls.SKIP)
        public Builder availableAccordingToOperators(Optional<Boolean> availableAccordingToOperators) {
            this.availableAccordingToOperators = availableAccordingToOperators;
            return this;
        }

        public Builder availableAccordingToOperators(Boolean availableAccordingToOperators) {
            this.availableAccordingToOperators = Optional.ofNullable(availableAccordingToOperators);
            return this;
        }

        public Builder availableAccordingToOperators(Nullable<Boolean> availableAccordingToOperators) {
            if (availableAccordingToOperators.isNull()) {
                this.availableAccordingToOperators = null;
            } else if (availableAccordingToOperators.isEmpty()) {
                this.availableAccordingToOperators = Optional.empty();
            } else {
                this.availableAccordingToOperators = Optional.of(availableAccordingToOperators.get());
            }
            return this;
        }

        public DriversListOrgMembersAndDriversV1Request build() {
            return new DriversListOrgMembersAndDriversV1Request(
                    availableAccordingToDriver, availableAccordingToOperators, additionalProperties);
        }
    }
}
