/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.offchrtshipperorg.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OffChrtShipperOrgClientUpdate1.Builder.class)
public final class OffChrtShipperOrgClientUpdate1 {
    private final Optional<String> industry;

    private final Optional<LocationFeature> streetAddress;

    private final Optional<String> contactFirstName;

    private final Optional<String> contactLastName;

    private final Optional<String> phoneNumberPrimary;

    private final Optional<String> phoneNumberSecondary;

    private final Optional<String> emailAddressPrimary;

    private final Optional<String> emailAddressSecondary;

    private final Optional<String> jobTitle;

    private final Optional<String> notes;

    private final Map<String, Object> additionalProperties;

    private OffChrtShipperOrgClientUpdate1(
            Optional<String> industry,
            Optional<LocationFeature> streetAddress,
            Optional<String> contactFirstName,
            Optional<String> contactLastName,
            Optional<String> phoneNumberPrimary,
            Optional<String> phoneNumberSecondary,
            Optional<String> emailAddressPrimary,
            Optional<String> emailAddressSecondary,
            Optional<String> jobTitle,
            Optional<String> notes,
            Map<String, Object> additionalProperties) {
        this.industry = industry;
        this.streetAddress = streetAddress;
        this.contactFirstName = contactFirstName;
        this.contactLastName = contactLastName;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.jobTitle = jobTitle;
        this.notes = notes;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getIndustry() {
        if (industry == null) {
            return Optional.empty();
        }
        return industry;
    }

    @JsonIgnore
    public Optional<LocationFeature> getStreetAddress() {
        if (streetAddress == null) {
            return Optional.empty();
        }
        return streetAddress;
    }

    @JsonIgnore
    public Optional<String> getContactFirstName() {
        if (contactFirstName == null) {
            return Optional.empty();
        }
        return contactFirstName;
    }

    @JsonIgnore
    public Optional<String> getContactLastName() {
        if (contactLastName == null) {
            return Optional.empty();
        }
        return contactLastName;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return phoneNumberSecondary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressPrimary() {
        if (emailAddressPrimary == null) {
            return Optional.empty();
        }
        return emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (emailAddressSecondary == null) {
            return Optional.empty();
        }
        return emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getJobTitle() {
        if (jobTitle == null) {
            return Optional.empty();
        }
        return jobTitle;
    }

    @JsonIgnore
    public Optional<String> getNotes() {
        if (notes == null) {
            return Optional.empty();
        }
        return notes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("industry")
    private Optional<String> _getIndustry() {
        return industry;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("street_address")
    private Optional<LocationFeature> _getStreetAddress() {
        return streetAddress;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("contact_first_name")
    private Optional<String> _getContactFirstName() {
        return contactFirstName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("contact_last_name")
    private Optional<String> _getContactLastName() {
        return contactLastName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return phoneNumberSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_primary")
    private Optional<String> _getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return emailAddressSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("job_title")
    private Optional<String> _getJobTitle() {
        return jobTitle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("notes")
    private Optional<String> _getNotes() {
        return notes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OffChrtShipperOrgClientUpdate1 && equalTo((OffChrtShipperOrgClientUpdate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OffChrtShipperOrgClientUpdate1 other) {
        return industry.equals(other.industry)
                && streetAddress.equals(other.streetAddress)
                && contactFirstName.equals(other.contactFirstName)
                && contactLastName.equals(other.contactLastName)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary)
                && phoneNumberSecondary.equals(other.phoneNumberSecondary)
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && emailAddressSecondary.equals(other.emailAddressSecondary)
                && jobTitle.equals(other.jobTitle)
                && notes.equals(other.notes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.industry,
                this.streetAddress,
                this.contactFirstName,
                this.contactLastName,
                this.phoneNumberPrimary,
                this.phoneNumberSecondary,
                this.emailAddressPrimary,
                this.emailAddressSecondary,
                this.jobTitle,
                this.notes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> industry = Optional.empty();

        private Optional<LocationFeature> streetAddress = Optional.empty();

        private Optional<String> contactFirstName = Optional.empty();

        private Optional<String> contactLastName = Optional.empty();

        private Optional<String> phoneNumberPrimary = Optional.empty();

        private Optional<String> phoneNumberSecondary = Optional.empty();

        private Optional<String> emailAddressPrimary = Optional.empty();

        private Optional<String> emailAddressSecondary = Optional.empty();

        private Optional<String> jobTitle = Optional.empty();

        private Optional<String> notes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(OffChrtShipperOrgClientUpdate1 other) {
            industry(other.getIndustry());
            streetAddress(other.getStreetAddress());
            contactFirstName(other.getContactFirstName());
            contactLastName(other.getContactLastName());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            phoneNumberSecondary(other.getPhoneNumberSecondary());
            emailAddressPrimary(other.getEmailAddressPrimary());
            emailAddressSecondary(other.getEmailAddressSecondary());
            jobTitle(other.getJobTitle());
            notes(other.getNotes());
            return this;
        }

        @JsonSetter(value = "industry", nulls = Nulls.SKIP)
        public Builder industry(Optional<String> industry) {
            this.industry = industry;
            return this;
        }

        public Builder industry(String industry) {
            this.industry = Optional.ofNullable(industry);
            return this;
        }

        public Builder industry(Nullable<String> industry) {
            if (industry.isNull()) {
                this.industry = null;
            } else if (industry.isEmpty()) {
                this.industry = Optional.empty();
            } else {
                this.industry = Optional.of(industry.get());
            }
            return this;
        }

        @JsonSetter(value = "street_address", nulls = Nulls.SKIP)
        public Builder streetAddress(Optional<LocationFeature> streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        public Builder streetAddress(LocationFeature streetAddress) {
            this.streetAddress = Optional.ofNullable(streetAddress);
            return this;
        }

        public Builder streetAddress(Nullable<LocationFeature> streetAddress) {
            if (streetAddress.isNull()) {
                this.streetAddress = null;
            } else if (streetAddress.isEmpty()) {
                this.streetAddress = Optional.empty();
            } else {
                this.streetAddress = Optional.of(streetAddress.get());
            }
            return this;
        }

        @JsonSetter(value = "contact_first_name", nulls = Nulls.SKIP)
        public Builder contactFirstName(Optional<String> contactFirstName) {
            this.contactFirstName = contactFirstName;
            return this;
        }

        public Builder contactFirstName(String contactFirstName) {
            this.contactFirstName = Optional.ofNullable(contactFirstName);
            return this;
        }

        public Builder contactFirstName(Nullable<String> contactFirstName) {
            if (contactFirstName.isNull()) {
                this.contactFirstName = null;
            } else if (contactFirstName.isEmpty()) {
                this.contactFirstName = Optional.empty();
            } else {
                this.contactFirstName = Optional.of(contactFirstName.get());
            }
            return this;
        }

        @JsonSetter(value = "contact_last_name", nulls = Nulls.SKIP)
        public Builder contactLastName(Optional<String> contactLastName) {
            this.contactLastName = contactLastName;
            return this;
        }

        public Builder contactLastName(String contactLastName) {
            this.contactLastName = Optional.ofNullable(contactLastName);
            return this;
        }

        public Builder contactLastName(Nullable<String> contactLastName) {
            if (contactLastName.isNull()) {
                this.contactLastName = null;
            } else if (contactLastName.isEmpty()) {
                this.contactLastName = Optional.empty();
            } else {
                this.contactLastName = Optional.of(contactLastName.get());
            }
            return this;
        }

        @JsonSetter(value = "phone_number_primary", nulls = Nulls.SKIP)
        public Builder phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        public Builder phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        public Builder phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            if (phoneNumberPrimary.isNull()) {
                this.phoneNumberPrimary = null;
            } else if (phoneNumberPrimary.isEmpty()) {
                this.phoneNumberPrimary = Optional.empty();
            } else {
                this.phoneNumberPrimary = Optional.of(phoneNumberPrimary.get());
            }
            return this;
        }

        @JsonSetter(value = "phone_number_secondary", nulls = Nulls.SKIP)
        public Builder phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        public Builder phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        public Builder phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            if (phoneNumberSecondary.isNull()) {
                this.phoneNumberSecondary = null;
            } else if (phoneNumberSecondary.isEmpty()) {
                this.phoneNumberSecondary = Optional.empty();
            } else {
                this.phoneNumberSecondary = Optional.of(phoneNumberSecondary.get());
            }
            return this;
        }

        @JsonSetter(value = "email_address_primary", nulls = Nulls.SKIP)
        public Builder emailAddressPrimary(Optional<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary;
            return this;
        }

        public Builder emailAddressPrimary(String emailAddressPrimary) {
            this.emailAddressPrimary = Optional.ofNullable(emailAddressPrimary);
            return this;
        }

        public Builder emailAddressPrimary(Nullable<String> emailAddressPrimary) {
            if (emailAddressPrimary.isNull()) {
                this.emailAddressPrimary = null;
            } else if (emailAddressPrimary.isEmpty()) {
                this.emailAddressPrimary = Optional.empty();
            } else {
                this.emailAddressPrimary = Optional.of(emailAddressPrimary.get());
            }
            return this;
        }

        @JsonSetter(value = "email_address_secondary", nulls = Nulls.SKIP)
        public Builder emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        public Builder emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        public Builder emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            if (emailAddressSecondary.isNull()) {
                this.emailAddressSecondary = null;
            } else if (emailAddressSecondary.isEmpty()) {
                this.emailAddressSecondary = Optional.empty();
            } else {
                this.emailAddressSecondary = Optional.of(emailAddressSecondary.get());
            }
            return this;
        }

        @JsonSetter(value = "job_title", nulls = Nulls.SKIP)
        public Builder jobTitle(Optional<String> jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = Optional.ofNullable(jobTitle);
            return this;
        }

        public Builder jobTitle(Nullable<String> jobTitle) {
            if (jobTitle.isNull()) {
                this.jobTitle = null;
            } else if (jobTitle.isEmpty()) {
                this.jobTitle = Optional.empty();
            } else {
                this.jobTitle = Optional.of(jobTitle.get());
            }
            return this;
        }

        @JsonSetter(value = "notes", nulls = Nulls.SKIP)
        public Builder notes(Optional<String> notes) {
            this.notes = notes;
            return this;
        }

        public Builder notes(String notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        public Builder notes(Nullable<String> notes) {
            if (notes.isNull()) {
                this.notes = null;
            } else if (notes.isEmpty()) {
                this.notes = Optional.empty();
            } else {
                this.notes = Optional.of(notes.get());
            }
            return this;
        }

        public OffChrtShipperOrgClientUpdate1 build() {
            return new OffChrtShipperOrgClientUpdate1(
                    industry,
                    streetAddress,
                    contactFirstName,
                    contactLastName,
                    phoneNumberPrimary,
                    phoneNumberSecondary,
                    emailAddressPrimary,
                    emailAddressSecondary,
                    jobTitle,
                    notes,
                    additionalProperties);
        }
    }
}
