/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orderdrafts.cargo.AsyncCargoClient;
import com.chrt.api.resources.orderdrafts.expanded.AsyncExpandedClient;
import com.chrt.api.resources.orderdrafts.requests.OrdersDraftUpdateReq;
import com.chrt.api.resources.orderdrafts.requests.OrdersNewDraftReq;
import com.chrt.api.resources.orderdrafts.task.AsyncTaskClient;
import com.chrt.api.resources.orderdrafts.taskartifact.AsyncTaskArtifactClient;
import com.chrt.api.resources.orderdrafts.taskgroup.AsyncTaskGroupClient;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderDraftExpanded;
import com.chrt.api.types.OrdersDraftUpdateRes;
import com.chrt.api.types.OrdersNewDraftRes;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncOrderDraftsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawOrderDraftsClient rawClient;

    protected final Supplier<AsyncTaskGroupClient> taskGroupClient;

    protected final Supplier<AsyncTaskClient> taskClient;

    protected final Supplier<AsyncTaskArtifactClient> taskArtifactClient;

    protected final Supplier<AsyncCargoClient> cargoClient;

    protected final Supplier<AsyncExpandedClient> expandedClient;

    public AsyncOrderDraftsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrderDraftsClient(clientOptions);
        this.taskGroupClient = Suppliers.memoize(() -> new AsyncTaskGroupClient(clientOptions));
        this.taskClient = Suppliers.memoize(() -> new AsyncTaskClient(clientOptions));
        this.taskArtifactClient = Suppliers.memoize(() -> new AsyncTaskArtifactClient(clientOptions));
        this.cargoClient = Suppliers.memoize(() -> new AsyncCargoClient(clientOptions));
        this.expandedClient = Suppliers.memoize(() -> new AsyncExpandedClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawOrderDraftsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates a new draft order with org assignments based on caller's organization type. | (OrdersNewDraftReq) -&gt; (OrdersNewDraftRes)
     */
    public CompletableFuture<OrdersNewDraftRes> newV1() {
        return this.rawClient.newV1().thenApply(response -> response.body());
    }

    /**
     * Creates a new draft order with org assignments based on caller's organization type. | (OrdersNewDraftReq) -&gt; (OrdersNewDraftRes)
     */
    public CompletableFuture<OrdersNewDraftRes> newV1(OrdersNewDraftReq request) {
        return this.rawClient.newV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new draft order with org assignments based on caller's organization type. | (OrdersNewDraftReq) -&gt; (OrdersNewDraftRes)
     */
    public CompletableFuture<OrdersNewDraftRes> newV1(OrdersNewDraftReq request, RequestOptions requestOptions) {
        return this.rawClient.newV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates forwarder and/or shipper org assignments for a draft order. | (OrdersDraftUpdateReq) -&gt; (OrdersDraftUpdateRes)
     */
    public CompletableFuture<OrdersDraftUpdateRes> updateV1(OrdersDraftUpdateReq request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates forwarder and/or shipper org assignments for a draft order. | (OrdersDraftUpdateReq) -&gt; (OrdersDraftUpdateRes)
     */
    public CompletableFuture<OrdersDraftUpdateRes> updateV1(
            OrdersDraftUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a draft order and all associated entities. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String orderId) {
        return this.rawClient.deleteV1(orderId).thenApply(response -> response.body());
    }

    /**
     * Deletes a draft order and all associated entities. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(orderId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Fetches a single draft order with optional expanded related data. Only the creator of the draft order can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public CompletableFuture<OrderDraftExpanded> expandedV1(String orderIdOrShortId) {
        return this.rawClient.expandedV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Fetches a single draft order with optional expanded related data. Only the creator of the draft order can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public CompletableFuture<OrderDraftExpanded> expandedV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return this.rawClient.expandedV1(orderIdOrShortId, request).thenApply(response -> response.body());
    }

    /**
     * Fetches a single draft order with optional expanded related data. Only the creator of the draft order can access it. | (OrderAndTaskGroupExpandedReq) -&gt; (OrderDraftExpanded)
     */
    public CompletableFuture<OrderDraftExpanded> expandedV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .expandedV1(orderIdOrShortId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Checks whether the draft order satisfies all requirements to move into staging. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> validateV1(String orderId) {
        return this.rawClient.validateV1(orderId).thenApply(response -> response.body());
    }

    /**
     * Checks whether the draft order satisfies all requirements to move into staging. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> validateV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.validateV1(orderId, requestOptions).thenApply(response -> response.body());
    }

    public AsyncTaskGroupClient taskGroup() {
        return this.taskGroupClient.get();
    }

    public AsyncTaskClient task() {
        return this.taskClient.get();
    }

    public AsyncTaskArtifactClient taskArtifact() {
        return this.taskArtifactClient.get();
    }

    public AsyncCargoClient cargo() {
        return this.cargoClient.get();
    }

    public AsyncExpandedClient expanded() {
        return this.expandedClient.get();
    }
}
