/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.cargo.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoClientCreate1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderDraftAddCargoReq.Builder.class)
public final class OrderDraftAddCargoReq {
    private final String orderId;

    private final CargoClientCreate1 cargo;

    private final Map<String, Object> additionalProperties;

    private OrderDraftAddCargoReq(String orderId, CargoClientCreate1 cargo, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.cargo = cargo;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("cargo")
    public CargoClientCreate1 getCargo() {
        return cargo;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderDraftAddCargoReq && equalTo((OrderDraftAddCargoReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftAddCargoReq other) {
        return orderId.equals(other.orderId) && cargo.equals(other.cargo);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.orderId, this.cargo);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    public interface OrderIdStage {
        CargoStage orderId(@NotNull String orderId);

        Builder from(OrderDraftAddCargoReq other);
    }

    public interface CargoStage {
        _FinalStage cargo(@NotNull CargoClientCreate1 cargo);
    }

    public interface _FinalStage {
        OrderDraftAddCargoReq build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrderIdStage, CargoStage, _FinalStage {
        private String orderId;

        private CargoClientCreate1 cargo;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrderDraftAddCargoReq other) {
            orderId(other.getOrderId());
            cargo(other.getCargo());
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public CargoStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo")
        public _FinalStage cargo(@NotNull CargoClientCreate1 cargo) {
            this.cargo = Objects.requireNonNull(cargo, "cargo must not be null");
            return this;
        }

        @java.lang.Override
        public OrderDraftAddCargoReq build() {
            return new OrderDraftAddCargoReq(orderId, cargo, additionalProperties);
        }
    }
}
