/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.cargo.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderDraftAssociateCargoWithTaskReq.Builder.class)
public final class OrderDraftAssociateCargoWithTaskReq {
    private final String orderId;

    private final String taskId;

    private final String cargoId;

    private final Map<String, Object> additionalProperties;

    private OrderDraftAssociateCargoWithTaskReq(
            String orderId, String taskId, String cargoId, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.taskId = taskId;
        this.cargoId = cargoId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("order_id")
    public String getOrderId() {
        return orderId;
    }

    @JsonProperty("task_id")
    public String getTaskId() {
        return taskId;
    }

    @JsonProperty("cargo_id")
    public String getCargoId() {
        return cargoId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderDraftAssociateCargoWithTaskReq
                && equalTo((OrderDraftAssociateCargoWithTaskReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftAssociateCargoWithTaskReq other) {
        return orderId.equals(other.orderId) && taskId.equals(other.taskId) && cargoId.equals(other.cargoId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.orderId, this.taskId, this.cargoId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    public interface OrderIdStage {
        TaskIdStage orderId(@NotNull String orderId);

        Builder from(OrderDraftAssociateCargoWithTaskReq other);
    }

    public interface TaskIdStage {
        CargoIdStage taskId(@NotNull String taskId);
    }

    public interface CargoIdStage {
        _FinalStage cargoId(@NotNull String cargoId);
    }

    public interface _FinalStage {
        OrderDraftAssociateCargoWithTaskReq build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrderIdStage, TaskIdStage, CargoIdStage, _FinalStage {
        private String orderId;

        private String taskId;

        private String cargoId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrderDraftAssociateCargoWithTaskReq other) {
            orderId(other.getOrderId());
            taskId(other.getTaskId());
            cargoId(other.getCargoId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("order_id")
        public TaskIdStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_id")
        public CargoIdStage taskId(@NotNull String taskId) {
            this.taskId = Objects.requireNonNull(taskId, "taskId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("cargo_id")
        public _FinalStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @java.lang.Override
        public OrderDraftAssociateCargoWithTaskReq build() {
            return new OrderDraftAssociateCargoWithTaskReq(orderId, taskId, cargoId, additionalProperties);
        }
    }
}
