/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.expanded.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.resources.orderdrafts.expanded.types.ExpandedListV1RequestSortOrder;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ExpandedListV1Request.Builder.class)
public final class ExpandedListV1Request {
    private final Optional<String> sortBy;

    private final Optional<ExpandedListV1RequestSortOrder> sortOrder;

    private final Optional<Integer> page;

    private final Optional<Integer> pageSize;

    private final Optional<OffsetDateTime> filterDraftStartedAtTimestampLte;

    private final Optional<OffsetDateTime> filterDraftStartedAtTimestampGte;

    private final OrderAndTaskGroupExpandedReq body;

    private final Map<String, Object> additionalProperties;

    private ExpandedListV1Request(
            Optional<String> sortBy,
            Optional<ExpandedListV1RequestSortOrder> sortOrder,
            Optional<Integer> page,
            Optional<Integer> pageSize,
            Optional<OffsetDateTime> filterDraftStartedAtTimestampLte,
            Optional<OffsetDateTime> filterDraftStartedAtTimestampGte,
            OrderAndTaskGroupExpandedReq body,
            Map<String, Object> additionalProperties) {
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.page = page;
        this.pageSize = pageSize;
        this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte;
        this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getSortBy() {
        if (sortBy == null) {
            return Optional.empty();
        }
        return sortBy;
    }

    @JsonIgnore
    public Optional<ExpandedListV1RequestSortOrder> getSortOrder() {
        if (sortOrder == null) {
            return Optional.empty();
        }
        return sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (page == null) {
            return Optional.empty();
        }
        return page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (pageSize == null) {
            return Optional.empty();
        }
        return pageSize;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtTimestampLte() {
        if (filterDraftStartedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterDraftStartedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtTimestampGte() {
        if (filterDraftStartedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterDraftStartedAtTimestampGte;
    }

    @JsonProperty("body")
    public OrderAndTaskGroupExpandedReq getBody() {
        return body;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_by")
    private Optional<String> _getSortBy() {
        return sortBy;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_order")
    private Optional<ExpandedListV1RequestSortOrder> _getSortOrder() {
        return sortOrder;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page")
    private Optional<Integer> _getPage() {
        return page;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page_size")
    private Optional<Integer> _getPageSize() {
        return pageSize;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_draft_started_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtTimestampLte() {
        return filterDraftStartedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_draft_started_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtTimestampGte() {
        return filterDraftStartedAtTimestampGte;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ExpandedListV1Request && equalTo((ExpandedListV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpandedListV1Request other) {
        return sortBy.equals(other.sortBy)
                && sortOrder.equals(other.sortOrder)
                && page.equals(other.page)
                && pageSize.equals(other.pageSize)
                && filterDraftStartedAtTimestampLte.equals(other.filterDraftStartedAtTimestampLte)
                && filterDraftStartedAtTimestampGte.equals(other.filterDraftStartedAtTimestampGte)
                && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.sortBy,
                this.sortOrder,
                this.page,
                this.pageSize,
                this.filterDraftStartedAtTimestampLte,
                this.filterDraftStartedAtTimestampGte,
                this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    public interface BodyStage {
        _FinalStage body(@NotNull OrderAndTaskGroupExpandedReq body);

        Builder from(ExpandedListV1Request other);
    }

    public interface _FinalStage {
        ExpandedListV1Request build();

        _FinalStage sortBy(Optional<String> sortBy);

        _FinalStage sortBy(String sortBy);

        _FinalStage sortBy(Nullable<String> sortBy);

        _FinalStage sortOrder(Optional<ExpandedListV1RequestSortOrder> sortOrder);

        _FinalStage sortOrder(ExpandedListV1RequestSortOrder sortOrder);

        _FinalStage sortOrder(Nullable<ExpandedListV1RequestSortOrder> sortOrder);

        _FinalStage page(Optional<Integer> page);

        _FinalStage page(Integer page);

        _FinalStage page(Nullable<Integer> page);

        _FinalStage pageSize(Optional<Integer> pageSize);

        _FinalStage pageSize(Integer pageSize);

        _FinalStage pageSize(Nullable<Integer> pageSize);

        _FinalStage filterDraftStartedAtTimestampLte(Optional<OffsetDateTime> filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampLte(OffsetDateTime filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampLte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampGte(Optional<OffsetDateTime> filterDraftStartedAtTimestampGte);

        _FinalStage filterDraftStartedAtTimestampGte(OffsetDateTime filterDraftStartedAtTimestampGte);

        _FinalStage filterDraftStartedAtTimestampGte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampGte);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements BodyStage, _FinalStage {
        private OrderAndTaskGroupExpandedReq body;

        private Optional<OffsetDateTime> filterDraftStartedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterDraftStartedAtTimestampLte = Optional.empty();

        private Optional<Integer> pageSize = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<ExpandedListV1RequestSortOrder> sortOrder = Optional.empty();

        private Optional<String> sortBy = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ExpandedListV1Request other) {
            sortBy(other.getSortBy());
            sortOrder(other.getSortOrder());
            page(other.getPage());
            pageSize(other.getPageSize());
            filterDraftStartedAtTimestampLte(other.getFilterDraftStartedAtTimestampLte());
            filterDraftStartedAtTimestampGte(other.getFilterDraftStartedAtTimestampGte());
            body(other.getBody());
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull OrderAndTaskGroupExpandedReq body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampGte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampGte) {
            if (filterDraftStartedAtTimestampGte.isNull()) {
                this.filterDraftStartedAtTimestampGte = null;
            } else if (filterDraftStartedAtTimestampGte.isEmpty()) {
                this.filterDraftStartedAtTimestampGte = Optional.empty();
            } else {
                this.filterDraftStartedAtTimestampGte = Optional.of(filterDraftStartedAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampGte(OffsetDateTime filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = Optional.ofNullable(filterDraftStartedAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_draft_started_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterDraftStartedAtTimestampGte(Optional<OffsetDateTime> filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampLte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampLte) {
            if (filterDraftStartedAtTimestampLte.isNull()) {
                this.filterDraftStartedAtTimestampLte = null;
            } else if (filterDraftStartedAtTimestampLte.isEmpty()) {
                this.filterDraftStartedAtTimestampLte = Optional.empty();
            } else {
                this.filterDraftStartedAtTimestampLte = Optional.of(filterDraftStartedAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampLte(OffsetDateTime filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = Optional.ofNullable(filterDraftStartedAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_draft_started_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterDraftStartedAtTimestampLte(Optional<OffsetDateTime> filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Nullable<Integer> pageSize) {
            if (pageSize.isNull()) {
                this.pageSize = null;
            } else if (pageSize.isEmpty()) {
                this.pageSize = Optional.empty();
            } else {
                this.pageSize = Optional.of(pageSize.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page_size", nulls = Nulls.SKIP)
        public _FinalStage pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Nullable<Integer> page) {
            if (page.isNull()) {
                this.page = null;
            } else if (page.isEmpty()) {
                this.page = Optional.empty();
            } else {
                this.page = Optional.of(page.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(Nullable<ExpandedListV1RequestSortOrder> sortOrder) {
            if (sortOrder.isNull()) {
                this.sortOrder = null;
            } else if (sortOrder.isEmpty()) {
                this.sortOrder = Optional.empty();
            } else {
                this.sortOrder = Optional.of(sortOrder.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(ExpandedListV1RequestSortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_order", nulls = Nulls.SKIP)
        public _FinalStage sortOrder(Optional<ExpandedListV1RequestSortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(Nullable<String> sortBy) {
            if (sortBy.isNull()) {
                this.sortBy = null;
            } else if (sortBy.isEmpty()) {
                this.sortBy = Optional.empty();
            } else {
                this.sortBy = Optional.of(sortBy.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(String sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_by", nulls = Nulls.SKIP)
        public _FinalStage sortBy(Optional<String> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @java.lang.Override
        public ExpandedListV1Request build() {
            return new ExpandedListV1Request(
                    sortBy,
                    sortOrder,
                    page,
                    pageSize,
                    filterDraftStartedAtTimestampLte,
                    filterDraftStartedAtTimestampGte,
                    body,
                    additionalProperties);
        }
    }
}
