/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.task;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.task.requests.OrderDraftAddTaskReqV1;
import com.chrt.api.resources.orderdrafts.task.requests.OrderDraftUpdateTaskReq;

public class TaskClient {
    protected final ClientOptions clientOptions;

    private final RawTaskClient rawClient;

    public TaskClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTaskClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a task to an existing task group in a draft order. Validates order is in DRAFT status and task action type matches task group type. | (OrderDraftAddTaskReqV1) -&gt; (PydanticObjectId)
     */
    public String addV1(OrderDraftAddTaskReqV1 request) {
        return this.rawClient.addV1(request).body();
    }

    /**
     * Adds a task to an existing task group in a draft order. Validates order is in DRAFT status and task action type matches task group type. | (OrderDraftAddTaskReqV1) -&gt; (PydanticObjectId)
     */
    public String addV1(OrderDraftAddTaskReqV1 request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).body();
    }

    /**
     * Updates a task in an existing draft order. | (OrderDraftUpdateTaskReq) -&gt; (PydanticObjectId)
     */
    public String updateV1(OrderDraftUpdateTaskReq request) {
        return this.rawClient.updateV1(request).body();
    }

    /**
     * Updates a task in an existing draft order. | (OrderDraftUpdateTaskReq) -&gt; (PydanticObjectId)
     */
    public String updateV1(OrderDraftUpdateTaskReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }

    /**
     * Deletes a task from a draft order, including all task artifacts. Cargo is preserved. Task is removed from task group. | () -&gt; (bool)
     */
    public boolean deleteV1(String taskId) {
        return this.rawClient.deleteV1(taskId).body();
    }

    /**
     * Deletes a task from a draft order, including all task artifacts. Cargo is preserved. Task is removed from task group. | () -&gt; (bool)
     */
    public boolean deleteV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskId, requestOptions).body();
    }
}
