/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orders.expanded.AsyncExpandedClient;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncOrdersClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawOrdersClient rawClient;

    protected final Supplier<AsyncExpandedClient> expandedClient;

    public AsyncOrdersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrdersClient(clientOptions);
        this.expandedClient = Suppliers.memoize(() -> new AsyncExpandedClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawOrdersClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Validates a draft order and stages all related entities in a transaction. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> stageV1(String orderId) {
        return this.rawClient.stageV1(orderId).thenApply(response -> response.body());
    }

    /**
     * Validates a draft order and stages all related entities in a transaction. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> stageV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.stageV1(orderId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Cancels an order and all related task groups and tasks in a transaction. | authz_personas=[lig_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> cancelV1(String orderId) {
        return this.rawClient.cancelV1(orderId).thenApply(response -> response.body());
    }

    /**
     * Cancels an order and all related task groups and tasks in a transaction. | authz_personas=[lig_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> cancelV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.cancelV1(orderId, requestOptions).thenApply(response -> response.body());
    }

    public AsyncExpandedClient expanded() {
        return this.expandedClient.get();
    }
}
