/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders.expanded;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForForwarderOperatorsV1Request;
import com.chrt.api.resources.orders.expanded.requests.ExpandedListForShipperOperatorsV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.OrderExpanded;
import com.chrt.api.types.OrdersExpandedListRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawExpandedClient {
    protected final ClientOptions clientOptions;

    public AsyncRawExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Retrieves an expanded order with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrderExpanded>> forShipperOperatorsV1(String orderIdOrShortId) {
        return forShipperOperatorsV1(
                orderIdOrShortId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    /**
     * Retrieves an expanded order with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrderExpanded>> forShipperOperatorsV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return forShipperOperatorsV1(orderIdOrShortId, request, null);
    }

    /**
     * Retrieves an expanded order with optional related data for shipper operators. | authz_personas=[shipper_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrderExpanded>> forShipperOperatorsV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/orders/expanded/for_shipper_operators/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<OrderExpanded>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderExpanded.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Retrieves an expanded order with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrderExpanded>> forForwarderOperatorsV1(String orderIdOrShortId) {
        return forForwarderOperatorsV1(
                orderIdOrShortId, OrderAndTaskGroupExpandedReq.builder().build());
    }

    /**
     * Retrieves an expanded order with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrderExpanded>> forForwarderOperatorsV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request) {
        return forForwarderOperatorsV1(orderIdOrShortId, request, null);
    }

    /**
     * Retrieves an expanded order with optional related data for forwarder operators. | authz_personas=[forwarder_org_operators] | (OrderAndTaskGroupExpandedReq) -&gt; (OrderExpanded)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrderExpanded>> forForwarderOperatorsV1(
            String orderIdOrShortId, OrderAndTaskGroupExpandedReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/orders/expanded/for_forwarder_operators/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<OrderExpanded>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderExpanded.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Lists expanded orders for forwarder operators with filtering, sorting, and pagination. | authz: allowed_org_types=[forwarder], min_org_role=operator | (OrderAndTaskGroupExpandedReq) -&gt; (OrdersExpandedListRes)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrdersExpandedListRes>> listForForwarderOperatorsV1(
            ExpandedListForForwarderOperatorsV1Request request) {
        return listForForwarderOperatorsV1(request, null);
    }

    /**
     * Lists expanded orders for forwarder operators with filtering, sorting, and pagination. | authz: allowed_org_types=[forwarder], min_org_role=operator | (OrderAndTaskGroupExpandedReq) -&gt; (OrdersExpandedListRes)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrdersExpandedListRes>> listForForwarderOperatorsV1(
            ExpandedListForForwarderOperatorsV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/orders/expanded/list/for_forwarder_operators/v1");
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_timestamp_lte",
                    request.getFilterDraftStartedAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterDraftStartedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_timestamp_gte",
                    request.getFilterDraftStartedAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterStagedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_staged_at_timestamp_lte",
                    request.getFilterStagedAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterStagedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_staged_at_timestamp_gte",
                    request.getFilterStagedAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterInProgressAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_in_progress_at_timestamp_lte",
                    request.getFilterInProgressAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterInProgressAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_in_progress_at_timestamp_gte",
                    request.getFilterInProgressAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterCompletedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_completed_at_timestamp_lte",
                    request.getFilterCompletedAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterCompletedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_completed_at_timestamp_gte",
                    request.getFilterCompletedAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterExceptionAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_exception_at_timestamp_lte",
                    request.getFilterExceptionAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterExceptionAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_exception_at_timestamp_gte",
                    request.getFilterExceptionAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterOrderCancelledAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_order_cancelled_at_timestamp_lte",
                    request.getFilterOrderCancelledAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterOrderCancelledAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_order_cancelled_at_timestamp_gte",
                    request.getFilterOrderCancelledAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_status", request.getFilterStatus().get(), true);
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<OrdersExpandedListRes>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrdersExpandedListRes.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Lists expanded orders for shipper operators with filtering, sorting, and pagination. | authz: allowed_org_types=[shipper], min_org_role=operator | (OrderAndTaskGroupExpandedReq) -&gt; (OrdersExpandedListRes)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrdersExpandedListRes>> listForShipperOperatorsV1(
            ExpandedListForShipperOperatorsV1Request request) {
        return listForShipperOperatorsV1(request, null);
    }

    /**
     * Lists expanded orders for shipper operators with filtering, sorting, and pagination. | authz: allowed_org_types=[shipper], min_org_role=operator | (OrderAndTaskGroupExpandedReq) -&gt; (OrdersExpandedListRes)
     */
    public CompletableFuture<ChrtApiHttpResponse<OrdersExpandedListRes>> listForShipperOperatorsV1(
            ExpandedListForShipperOperatorsV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/orders/expanded/list/for_shipper_operators/v1");
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getFilterDraftStartedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_timestamp_lte",
                    request.getFilterDraftStartedAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterDraftStartedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_timestamp_gte",
                    request.getFilterDraftStartedAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterStagedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_staged_at_timestamp_lte",
                    request.getFilterStagedAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterStagedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_staged_at_timestamp_gte",
                    request.getFilterStagedAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterInProgressAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_in_progress_at_timestamp_lte",
                    request.getFilterInProgressAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterInProgressAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_in_progress_at_timestamp_gte",
                    request.getFilterInProgressAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterCompletedAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_completed_at_timestamp_lte",
                    request.getFilterCompletedAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterCompletedAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_completed_at_timestamp_gte",
                    request.getFilterCompletedAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterExceptionAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_exception_at_timestamp_lte",
                    request.getFilterExceptionAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterExceptionAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_exception_at_timestamp_gte",
                    request.getFilterExceptionAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterOrderCancelledAtTimestampLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_order_cancelled_at_timestamp_lte",
                    request.getFilterOrderCancelledAtTimestampLte().get(),
                    false);
        }
        if (request.getFilterOrderCancelledAtTimestampGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_order_cancelled_at_timestamp_gte",
                    request.getFilterOrderCancelledAtTimestampGte().get(),
                    false);
        }
        if (request.getFilterStatus().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_status", request.getFilterStatus().get(), true);
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<OrdersExpandedListRes>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrdersExpandedListRes.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
