/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orginfoforconnections.forwarder;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orginfoforconnections.forwarder.requests.ForwarderOrgInfoForConnectionsClientCreate1;
import com.chrt.api.resources.orginfoforconnections.forwarder.requests.ForwarderOrgInfoForConnectionsClientUpdate1;
import com.chrt.api.types.ForwarderOrgInfoForConnections1;
import java.util.concurrent.CompletableFuture;

public class AsyncForwarderClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawForwarderClient rawClient;

    public AsyncForwarderClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawForwarderClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawForwarderClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves forwarder organization connection information for the caller's organization. | () -&gt; (ForwarderOrgInfoForConnections1)
     */
    public CompletableFuture<ForwarderOrgInfoForConnections1> getV1() {
        return this.rawClient.getV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves forwarder organization connection information for the caller's organization. | () -&gt; (ForwarderOrgInfoForConnections1)
     */
    public CompletableFuture<ForwarderOrgInfoForConnections1> getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates forwarder organization connection information. Fails if already exists. | (ForwarderOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(ForwarderOrgInfoForConnectionsClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates forwarder organization connection information. Fails if already exists. | (ForwarderOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(
            ForwarderOrgInfoForConnectionsClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates existing forwarder organization connection information. | (ForwarderOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1() {
        return this.rawClient.updateV1().thenApply(response -> response.body());
    }

    /**
     * Updates existing forwarder organization connection information. | (ForwarderOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(ForwarderOrgInfoForConnectionsClientUpdate1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates existing forwarder organization connection information. | (ForwarderOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(
            ForwarderOrgInfoForConnectionsClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }
}
