/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orginfoforconnections.forwarder;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orginfoforconnections.forwarder.requests.ForwarderOrgInfoForConnectionsClientCreate1;
import com.chrt.api.resources.orginfoforconnections.forwarder.requests.ForwarderOrgInfoForConnectionsClientUpdate1;
import com.chrt.api.types.ForwarderOrgInfoForConnections1;

public class ForwarderClient {
    protected final ClientOptions clientOptions;

    private final RawForwarderClient rawClient;

    public ForwarderClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawForwarderClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawForwarderClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves forwarder organization connection information for the caller's organization. | () -&gt; (ForwarderOrgInfoForConnections1)
     */
    public ForwarderOrgInfoForConnections1 getV1() {
        return this.rawClient.getV1().body();
    }

    /**
     * Retrieves forwarder organization connection information for the caller's organization. | () -&gt; (ForwarderOrgInfoForConnections1)
     */
    public ForwarderOrgInfoForConnections1 getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).body();
    }

    /**
     * Creates forwarder organization connection information. Fails if already exists. | (ForwarderOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(ForwarderOrgInfoForConnectionsClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates forwarder organization connection information. Fails if already exists. | (ForwarderOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(ForwarderOrgInfoForConnectionsClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Updates existing forwarder organization connection information. | (ForwarderOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1() {
        return this.rawClient.updateV1().body();
    }

    /**
     * Updates existing forwarder organization connection information. | (ForwarderOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(ForwarderOrgInfoForConnectionsClientUpdate1 request) {
        return this.rawClient.updateV1(request).body();
    }

    /**
     * Updates existing forwarder organization connection information. | (ForwarderOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(ForwarderOrgInfoForConnectionsClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }
}
