/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orginfoforconnections.shipper;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orginfoforconnections.shipper.requests.ShipperOrgInfoForConnectionsClientCreate1;
import com.chrt.api.resources.orginfoforconnections.shipper.requests.ShipperOrgInfoForConnectionsClientUpdate1;
import com.chrt.api.types.ShipperOrgInfoForConnections1;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawShipperClient rawClient;

    public AsyncShipperClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawShipperClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves shipper organization connection information for the caller's organization. | () -&gt; (ShipperOrgInfoForConnections1)
     */
    public CompletableFuture<ShipperOrgInfoForConnections1> getV1() {
        return this.rawClient.getV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves shipper organization connection information for the caller's organization. | () -&gt; (ShipperOrgInfoForConnections1)
     */
    public CompletableFuture<ShipperOrgInfoForConnections1> getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates shipper organization connection information. Fails if already exists. | (ShipperOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(ShipperOrgInfoForConnectionsClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates shipper organization connection information. Fails if already exists. | (ShipperOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(
            ShipperOrgInfoForConnectionsClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper organization connection information. | (ShipperOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1() {
        return this.rawClient.updateV1().thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper organization connection information. | (ShipperOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(ShipperOrgInfoForConnectionsClientUpdate1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper organization connection information. | (ShipperOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(
            ShipperOrgInfoForConnectionsClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }
}
