/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierlineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.addlineitems.AsyncAddLineItemsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.courier.AsyncCourierClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.removelineitems.AsyncRemoveLineItemsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.shipper.AsyncShipperClient;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import com.chrt.api.types.ShipperPayCourierLineItemGroupCreateReq;
import com.chrt.api.types.ShipperPayCourierLineItemGroupServerCreate1;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncShipperPayCourierLineItemGroupsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawShipperPayCourierLineItemGroupsClient rawClient;

    protected final Supplier<AsyncShipperClient> shipperClient;

    protected final Supplier<AsyncCourierClient> courierClient;

    protected final Supplier<AsyncAddLineItemsClient> addLineItemsClient;

    protected final Supplier<AsyncRemoveLineItemsClient> removeLineItemsClient;

    public AsyncShipperPayCourierLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperPayCourierLineItemGroupsClient(clientOptions);
        this.shipperClient = Suppliers.memoize(() -> new AsyncShipperClient(clientOptions));
        this.courierClient = Suppliers.memoize(() -> new AsyncCourierClient(clientOptions));
        this.addLineItemsClient = Suppliers.memoize(() -> new AsyncAddLineItemsClient(clientOptions));
        this.removeLineItemsClient = Suppliers.memoize(() -> new AsyncRemoveLineItemsClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawShipperPayCourierLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a shipper pay courier line item group by its ID for the caller's courier organization. | () -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public CompletableFuture<ShipperPayCourierLineItemGroup1> getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier line item group by its ID for the caller's courier organization. | () -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public CompletableFuture<ShipperPayCourierLineItemGroup1> getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a shipper pay courier line item group by its ID if not referenced by any payment. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Deletes a shipper pay courier line item group by its ID if not referenced by any payment. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier line item group by its associated task group ID for the caller's courier organization. | () -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public CompletableFuture<ShipperPayCourierLineItemGroup1> byTaskGroupIdV1(String taskGroupId) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier line item group by its associated task group ID for the caller's courier organization. | () -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public CompletableFuture<ShipperPayCourierLineItemGroup1> byTaskGroupIdV1(
            String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Previews calculated line items for a shipper pay courier based on rate sheet and task group without creating the group. | (ShipperPayCourierLineItemGroupCreateReq) -&gt; (ShipperPayCourierLineItemGroupServerCreate1)
     */
    public CompletableFuture<ShipperPayCourierLineItemGroupServerCreate1> previewV1(
            ShipperPayCourierLineItemGroupCreateReq request) {
        return this.rawClient.previewV1(request).thenApply(response -> response.body());
    }

    /**
     * Previews calculated line items for a shipper pay courier based on rate sheet and task group without creating the group. | (ShipperPayCourierLineItemGroupCreateReq) -&gt; (ShipperPayCourierLineItemGroupServerCreate1)
     */
    public CompletableFuture<ShipperPayCourierLineItemGroupServerCreate1> previewV1(
            ShipperPayCourierLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a shipper pay courier line item group by calculating items from rate sheet and task group. | (ShipperPayCourierLineItemGroupCreateReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(ShipperPayCourierLineItemGroupCreateReq request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a shipper pay courier line item group by calculating items from rate sheet and task group. | (ShipperPayCourierLineItemGroupCreateReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(
            ShipperPayCourierLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    public AsyncShipperClient shipper() {
        return this.shipperClient.get();
    }

    public AsyncCourierClient courier() {
        return this.courierClient.get();
    }

    public AsyncAddLineItemsClient addLineItems() {
        return this.addLineItemsClient.get();
    }

    public AsyncRemoveLineItemsClient removeLineItems() {
        return this.removeLineItemsClient.get();
    }
}
