/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierlineitemgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.addlineitems.AddLineItemsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.courier.CourierClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.removelineitems.RemoveLineItemsClient;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.shipper.ShipperClient;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import com.chrt.api.types.ShipperPayCourierLineItemGroupCreateReq;
import com.chrt.api.types.ShipperPayCourierLineItemGroupServerCreate1;
import java.util.function.Supplier;

public class ShipperPayCourierLineItemGroupsClient {
    protected final ClientOptions clientOptions;

    private final RawShipperPayCourierLineItemGroupsClient rawClient;

    protected final Supplier<ShipperClient> shipperClient;

    protected final Supplier<CourierClient> courierClient;

    protected final Supplier<AddLineItemsClient> addLineItemsClient;

    protected final Supplier<RemoveLineItemsClient> removeLineItemsClient;

    public ShipperPayCourierLineItemGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperPayCourierLineItemGroupsClient(clientOptions);
        this.shipperClient = Suppliers.memoize(() -> new ShipperClient(clientOptions));
        this.courierClient = Suppliers.memoize(() -> new CourierClient(clientOptions));
        this.addLineItemsClient = Suppliers.memoize(() -> new AddLineItemsClient(clientOptions));
        this.removeLineItemsClient = Suppliers.memoize(() -> new RemoveLineItemsClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawShipperPayCourierLineItemGroupsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a shipper pay courier line item group by its ID for the caller's courier organization. | () -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public ShipperPayCourierLineItemGroup1 getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).body();
    }

    /**
     * Retrieves a shipper pay courier line item group by its ID for the caller's courier organization. | () -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public ShipperPayCourierLineItemGroup1 getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).body();
    }

    /**
     * Deletes a shipper pay courier line item group by its ID if not referenced by any payment. | () -&gt; (bool)
     */
    public boolean deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).body();
    }

    /**
     * Deletes a shipper pay courier line item group by its ID if not referenced by any payment. | () -&gt; (bool)
     */
    public boolean deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).body();
    }

    /**
     * Retrieves a shipper pay courier line item group by its associated task group ID for the caller's courier organization. | () -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public ShipperPayCourierLineItemGroup1 byTaskGroupIdV1(String taskGroupId) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId).body();
    }

    /**
     * Retrieves a shipper pay courier line item group by its associated task group ID for the caller's courier organization. | () -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public ShipperPayCourierLineItemGroup1 byTaskGroupIdV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId, requestOptions).body();
    }

    /**
     * Previews calculated line items for a shipper pay courier based on rate sheet and task group without creating the group. | (ShipperPayCourierLineItemGroupCreateReq) -&gt; (ShipperPayCourierLineItemGroupServerCreate1)
     */
    public ShipperPayCourierLineItemGroupServerCreate1 previewV1(ShipperPayCourierLineItemGroupCreateReq request) {
        return this.rawClient.previewV1(request).body();
    }

    /**
     * Previews calculated line items for a shipper pay courier based on rate sheet and task group without creating the group. | (ShipperPayCourierLineItemGroupCreateReq) -&gt; (ShipperPayCourierLineItemGroupServerCreate1)
     */
    public ShipperPayCourierLineItemGroupServerCreate1 previewV1(
            ShipperPayCourierLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(request, requestOptions).body();
    }

    /**
     * Creates a shipper pay courier line item group by calculating items from rate sheet and task group. | (ShipperPayCourierLineItemGroupCreateReq) -&gt; (PydanticObjectId)
     */
    public String createV1(ShipperPayCourierLineItemGroupCreateReq request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates a shipper pay courier line item group by calculating items from rate sheet and task group. | (ShipperPayCourierLineItemGroupCreateReq) -&gt; (PydanticObjectId)
     */
    public String createV1(ShipperPayCourierLineItemGroupCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    public ShipperClient shipper() {
        return this.shipperClient.get();
    }

    public CourierClient courier() {
        return this.courierClient.get();
    }

    public AddLineItemsClient addLineItems() {
        return this.addLineItemsClient.get();
    }

    public RemoveLineItemsClient removeLineItems() {
        return this.removeLineItemsClient.get();
    }
}
