/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierlineitemgroups.addlineitems;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.shipperpaycourierlineitemgroups.addlineitems.requests.ShipperPayCourierLineItemGroupAddLineItemsReq;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawAddLineItemsClient {
    protected final ClientOptions clientOptions;

    public RawAddLineItemsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Adds additional line items to an existing shipper pay courier line item group. | (ShipperPayCourierLineItemGroupAddLineItemsReq) -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1> byIdV1(
            String id, ShipperPayCourierLineItemGroupAddLineItemsReq request) {
        return byIdV1(id, request, null);
    }

    /**
     * Adds additional line items to an existing shipper pay courier line item group. | (ShipperPayCourierLineItemGroupAddLineItemsReq) -&gt; (ShipperPayCourierLineItemGroup1)
     */
    public ChrtApiHttpResponse<ShipperPayCourierLineItemGroup1> byIdV1(
            String id, ShipperPayCourierLineItemGroupAddLineItemsReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/shipper_pay_courier_line_item_groups/add_line_items/v1")
                .addPathSegment(id)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PATCH", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ShipperPayCourierLineItemGroup1.class),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
