/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierpayments;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shipperpaycourierpayments.requests.ListPaymentsByCourierReq;
import com.chrt.api.resources.shipperpaycourierpayments.requests.ListPaymentsByShipperReq;
import com.chrt.api.types.CreateShipperPayCourierPaymentReq;
import com.chrt.api.types.GetShipperPayCourierPaymentsForShipperRes;
import com.chrt.api.types.PaymentPreviewResponse;
import com.chrt.api.types.ShipperPayCourierStatement1;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperPayCourierPaymentsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawShipperPayCourierPaymentsClient rawClient;

    public AsyncShipperPayCourierPaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperPayCourierPaymentsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawShipperPayCourierPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a shipper pay courier payment by its ID with Stripe invoice sync. | () -&gt; (ShipperPayCourierStatement1)
     */
    public CompletableFuture<ShipperPayCourierStatement1> getByIdV1(String shipperPayCourierPaymentId) {
        return this.rawClient.getByIdV1(shipperPayCourierPaymentId).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier payment by its ID with Stripe invoice sync. | () -&gt; (ShipperPayCourierStatement1)
     */
    public CompletableFuture<ShipperPayCourierStatement1> getByIdV1(
            String shipperPayCourierPaymentId, RequestOptions requestOptions) {
        return this.rawClient
                .getByIdV1(shipperPayCourierPaymentId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Deletes a shipper-to-courier payment record if invoice not yet created. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String shipperPayCourierPaymentId) {
        return this.rawClient.deleteV1(shipperPayCourierPaymentId).thenApply(response -> response.body());
    }

    /**
     * Deletes a shipper-to-courier payment record if invoice not yet created. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String shipperPayCourierPaymentId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteV1(shipperPayCourierPaymentId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier payment by order ID or short ID with Stripe invoice sync. | () -&gt; (ShipperPayCourierStatement1)
     */
    public CompletableFuture<ShipperPayCourierStatement1> getByOrderIdOrShortIdV1(String orderIdOrShortId) {
        return this.rawClient.getByOrderIdOrShortIdV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier payment by order ID or short ID with Stripe invoice sync. | () -&gt; (ShipperPayCourierStatement1)
     */
    public CompletableFuture<ShipperPayCourierStatement1> getByOrderIdOrShortIdV1(
            String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient
                .getByOrderIdOrShortIdV1(orderIdOrShortId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists shipper pay courier payments by shipper org ID with status filtering and Stripe sync. | (ListPaymentsByShipperReq) -&gt; (GetShipperPayCourierPaymentsForShipperRes)
     */
    public CompletableFuture<GetShipperPayCourierPaymentsForShipperRes> listByShipperOrgIdV1(
            ListPaymentsByShipperReq request) {
        return this.rawClient.listByShipperOrgIdV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists shipper pay courier payments by shipper org ID with status filtering and Stripe sync. | (ListPaymentsByShipperReq) -&gt; (GetShipperPayCourierPaymentsForShipperRes)
     */
    public CompletableFuture<GetShipperPayCourierPaymentsForShipperRes> listByShipperOrgIdV1(
            ListPaymentsByShipperReq request, RequestOptions requestOptions) {
        return this.rawClient.listByShipperOrgIdV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists shipper pay courier payments by courier org ID with status filtering and Stripe sync. | (ListPaymentsByCourierReq) -&gt; (GetShipperPayCourierPaymentsForShipperRes)
     */
    public CompletableFuture<GetShipperPayCourierPaymentsForShipperRes> listByCourierOrgIdV1(
            ListPaymentsByCourierReq request) {
        return this.rawClient.listByCourierOrgIdV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists shipper pay courier payments by courier org ID with status filtering and Stripe sync. | (ListPaymentsByCourierReq) -&gt; (GetShipperPayCourierPaymentsForShipperRes)
     */
    public CompletableFuture<GetShipperPayCourierPaymentsForShipperRes> listByCourierOrgIdV1(
            ListPaymentsByCourierReq request, RequestOptions requestOptions) {
        return this.rawClient.listByCourierOrgIdV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a shipper-to-courier payment record based on all task groups in an order. | (CreateShipperPayCourierPaymentReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(CreateShipperPayCourierPaymentReq request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a shipper-to-courier payment record based on all task groups in an order. | (CreateShipperPayCourierPaymentReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(
            CreateShipperPayCourierPaymentReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Previews a shipper-to-courier payment showing task groups, line item groups, total amount, and readiness status. | (CreateShipperPayCourierPaymentReq) -&gt; (PaymentPreviewResponse)
     */
    public CompletableFuture<PaymentPreviewResponse> previewV1(CreateShipperPayCourierPaymentReq request) {
        return this.rawClient.previewV1(request).thenApply(response -> response.body());
    }

    /**
     * Previews a shipper-to-courier payment showing task groups, line item groups, total amount, and readiness status. | (CreateShipperPayCourierPaymentReq) -&gt; (PaymentPreviewResponse)
     */
    public CompletableFuture<PaymentPreviewResponse> previewV1(
            CreateShipperPayCourierPaymentReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(request, requestOptions).thenApply(response -> response.body());
    }
}
