/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierpayments.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.StripeConnectInvoiceStatusEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListPaymentsByShipperReq.Builder.class)
public final class ListPaymentsByShipperReq {
    private final List<StripeConnectInvoiceStatusEnum> statuses;

    private final Optional<String> courierOrgId;

    private final Map<String, Object> additionalProperties;

    private ListPaymentsByShipperReq(
            List<StripeConnectInvoiceStatusEnum> statuses,
            Optional<String> courierOrgId,
            Map<String, Object> additionalProperties) {
        this.statuses = statuses;
        this.courierOrgId = courierOrgId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("statuses")
    public List<StripeConnectInvoiceStatusEnum> getStatuses() {
        return statuses;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getCourierOrgId() {
        if (courierOrgId == null) {
            return Optional.empty();
        }
        return courierOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("courier_org_id")
    private Optional<String> _getCourierOrgId() {
        return courierOrgId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListPaymentsByShipperReq && equalTo((ListPaymentsByShipperReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPaymentsByShipperReq other) {
        return statuses.equals(other.statuses) && courierOrgId.equals(other.courierOrgId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.statuses, this.courierOrgId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<StripeConnectInvoiceStatusEnum> statuses = new ArrayList<>();

        private Optional<String> courierOrgId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListPaymentsByShipperReq other) {
            statuses(other.getStatuses());
            courierOrgId(other.getCourierOrgId());
            return this;
        }

        @JsonSetter(value = "statuses", nulls = Nulls.SKIP)
        public Builder statuses(List<StripeConnectInvoiceStatusEnum> statuses) {
            this.statuses.clear();
            if (statuses != null) {
                this.statuses.addAll(statuses);
            }
            return this;
        }

        public Builder addStatuses(StripeConnectInvoiceStatusEnum statuses) {
            this.statuses.add(statuses);
            return this;
        }

        public Builder addAllStatuses(List<StripeConnectInvoiceStatusEnum> statuses) {
            if (statuses != null) {
                this.statuses.addAll(statuses);
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @JsonSetter(value = "courier_org_id", nulls = Nulls.SKIP)
        public Builder courierOrgId(Optional<String> courierOrgId) {
            this.courierOrgId = courierOrgId;
            return this;
        }

        public Builder courierOrgId(String courierOrgId) {
            this.courierOrgId = Optional.ofNullable(courierOrgId);
            return this;
        }

        public Builder courierOrgId(Nullable<String> courierOrgId) {
            if (courierOrgId.isNull()) {
                this.courierOrgId = null;
            } else if (courierOrgId.isEmpty()) {
                this.courierOrgId = Optional.empty();
            } else {
                this.courierOrgId = Optional.of(courierOrgId.get());
            }
            return this;
        }

        public ListPaymentsByShipperReq build() {
            return new ListPaymentsByShipperReq(statuses, courierOrgId, additionalProperties);
        }
    }
}
