/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierratesheets;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shipperpaycourierratesheets.requests.ShipperPayCourierRateSheetClientCreate1;
import com.chrt.api.resources.shipperpaycourierratesheets.requests.ShipperPayCourierRateSheetClientUpdate1;
import com.chrt.api.types.ShipperPayCourierRateSheet1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperPayCourierRateSheetsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawShipperPayCourierRateSheetsClient rawClient;

    public AsyncShipperPayCourierRateSheetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperPayCourierRateSheetsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawShipperPayCourierRateSheetsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists all rate sheets created by the authenticated courier organization. | () -&gt; (list[ShipperPayCourierRateSheet1])
     */
    public CompletableFuture<List<ShipperPayCourierRateSheet1>> listByCourierOrgIdV1() {
        return this.rawClient.listByCourierOrgIdV1().thenApply(response -> response.body());
    }

    /**
     * Lists all rate sheets created by the authenticated courier organization. | () -&gt; (list[ShipperPayCourierRateSheet1])
     */
    public CompletableFuture<List<ShipperPayCourierRateSheet1>> listByCourierOrgIdV1(RequestOptions requestOptions) {
        return this.rawClient.listByCourierOrgIdV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new rate sheet for a courier to charge shippers. | (ShipperPayCourierRateSheetClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(ShipperPayCourierRateSheetClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new rate sheet for a courier to charge shippers. | (ShipperPayCourierRateSheetClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(
            ShipperPayCourierRateSheetClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a single rate sheet by its ID (courier access only). | () -&gt; (ShipperPayCourierRateSheet1)
     */
    public CompletableFuture<ShipperPayCourierRateSheet1> getV1(String id) {
        return this.rawClient.getV1(id).thenApply(response -> response.body());
    }

    /**
     * Retrieves a single rate sheet by its ID (courier access only). | () -&gt; (ShipperPayCourierRateSheet1)
     */
    public CompletableFuture<ShipperPayCourierRateSheet1> getV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a rate sheet owned by the authenticated courier organization. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Deletes a rate sheet owned by the authenticated courier organization. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates an existing rate sheet owned by the authenticated courier organization. | (ShipperPayCourierRateSheetClientUpdate1) -&gt; (ShipperPayCourierRateSheet1)
     */
    public CompletableFuture<ShipperPayCourierRateSheet1> updateByIdV1(String id) {
        return this.rawClient.updateByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Updates an existing rate sheet owned by the authenticated courier organization. | (ShipperPayCourierRateSheetClientUpdate1) -&gt; (ShipperPayCourierRateSheet1)
     */
    public CompletableFuture<ShipperPayCourierRateSheet1> updateByIdV1(
            String id, ShipperPayCourierRateSheetClientUpdate1 request) {
        return this.rawClient.updateByIdV1(id, request).thenApply(response -> response.body());
    }

    /**
     * Updates an existing rate sheet owned by the authenticated courier organization. | (ShipperPayCourierRateSheetClientUpdate1) -&gt; (ShipperPayCourierRateSheet1)
     */
    public CompletableFuture<ShipperPayCourierRateSheet1> updateByIdV1(
            String id, ShipperPayCourierRateSheetClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateByIdV1(id, request, requestOptions).thenApply(response -> response.body());
    }
}
