/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierratesheets;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shipperpaycourierratesheets.requests.ShipperPayCourierRateSheetClientCreate1;
import com.chrt.api.resources.shipperpaycourierratesheets.requests.ShipperPayCourierRateSheetClientUpdate1;
import com.chrt.api.types.ShipperPayCourierRateSheet1;
import java.util.List;

public class ShipperPayCourierRateSheetsClient {
    protected final ClientOptions clientOptions;

    private final RawShipperPayCourierRateSheetsClient rawClient;

    public ShipperPayCourierRateSheetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperPayCourierRateSheetsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawShipperPayCourierRateSheetsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists all rate sheets created by the authenticated courier organization. | () -&gt; (list[ShipperPayCourierRateSheet1])
     */
    public List<ShipperPayCourierRateSheet1> listByCourierOrgIdV1() {
        return this.rawClient.listByCourierOrgIdV1().body();
    }

    /**
     * Lists all rate sheets created by the authenticated courier organization. | () -&gt; (list[ShipperPayCourierRateSheet1])
     */
    public List<ShipperPayCourierRateSheet1> listByCourierOrgIdV1(RequestOptions requestOptions) {
        return this.rawClient.listByCourierOrgIdV1(requestOptions).body();
    }

    /**
     * Creates a new rate sheet for a courier to charge shippers. | (ShipperPayCourierRateSheetClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(ShipperPayCourierRateSheetClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates a new rate sheet for a courier to charge shippers. | (ShipperPayCourierRateSheetClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(ShipperPayCourierRateSheetClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Retrieves a single rate sheet by its ID (courier access only). | () -&gt; (ShipperPayCourierRateSheet1)
     */
    public ShipperPayCourierRateSheet1 getV1(String id) {
        return this.rawClient.getV1(id).body();
    }

    /**
     * Retrieves a single rate sheet by its ID (courier access only). | () -&gt; (ShipperPayCourierRateSheet1)
     */
    public ShipperPayCourierRateSheet1 getV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getV1(id, requestOptions).body();
    }

    /**
     * Deletes a rate sheet owned by the authenticated courier organization. | () -&gt; (bool)
     */
    public boolean deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).body();
    }

    /**
     * Deletes a rate sheet owned by the authenticated courier organization. | () -&gt; (bool)
     */
    public boolean deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).body();
    }

    /**
     * Updates an existing rate sheet owned by the authenticated courier organization. | (ShipperPayCourierRateSheetClientUpdate1) -&gt; (ShipperPayCourierRateSheet1)
     */
    public ShipperPayCourierRateSheet1 updateByIdV1(String id) {
        return this.rawClient.updateByIdV1(id).body();
    }

    /**
     * Updates an existing rate sheet owned by the authenticated courier organization. | (ShipperPayCourierRateSheetClientUpdate1) -&gt; (ShipperPayCourierRateSheet1)
     */
    public ShipperPayCourierRateSheet1 updateByIdV1(String id, ShipperPayCourierRateSheetClientUpdate1 request) {
        return this.rawClient.updateByIdV1(id, request).body();
    }

    /**
     * Updates an existing rate sheet owned by the authenticated courier organization. | (ShipperPayCourierRateSheetClientUpdate1) -&gt; (ShipperPayCourierRateSheet1)
     */
    public ShipperPayCourierRateSheet1 updateByIdV1(
            String id, ShipperPayCourierRateSheetClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateByIdV1(id, request, requestOptions).body();
    }
}
