/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierratesheets.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoTypeEnum1;
import com.chrt.api.types.RouteTypeEnum1;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShipperPayCourierRateSheetClientUpdate1.Builder.class)
public final class ShipperPayCourierRateSheetClientUpdate1 {
    private final Optional<String> name;

    private final Optional<List<CargoTypeEnum1>> cargoTypes;

    private final Optional<List<VehicleTypeEnum>> vehicleTypes;

    private final Optional<List<RouteTypeEnum1>> routeTypes;

    private final Optional<String> shipperOrgId;

    private final Optional<String> offChrtShipperOrgId;

    private final Optional<String> comments;

    private final Optional<Double> baseMileageDistanceMiles;

    private final Optional<Double> baseMileageRateUsdPerInstance;

    private final Optional<Double> additionalMileageRateUsdPerMile;

    private final Optional<Double> longDistanceSurchargeMilesBeforeSurcharge;

    private final Optional<Double> longDistanceSurchargeRateUsdPerMile;

    private final Optional<Double> fuelSurchargeRateUsdPerMile;

    private final Optional<Double> waitTimeBeforeChargeMinutes;

    private final Optional<Double> waitTimeRateUsdPerMinute;

    private final Optional<Double> extraStopRateUsd;

    private final Optional<Double> dangerousGoodsRateUsdPerInstance;

    private final Optional<Double> afterHours;

    private final Optional<Double> weekend;

    private final Optional<Double> holiday;

    private final Map<String, Object> additionalProperties;

    private ShipperPayCourierRateSheetClientUpdate1(
            Optional<String> name,
            Optional<List<CargoTypeEnum1>> cargoTypes,
            Optional<List<VehicleTypeEnum>> vehicleTypes,
            Optional<List<RouteTypeEnum1>> routeTypes,
            Optional<String> shipperOrgId,
            Optional<String> offChrtShipperOrgId,
            Optional<String> comments,
            Optional<Double> baseMileageDistanceMiles,
            Optional<Double> baseMileageRateUsdPerInstance,
            Optional<Double> additionalMileageRateUsdPerMile,
            Optional<Double> longDistanceSurchargeMilesBeforeSurcharge,
            Optional<Double> longDistanceSurchargeRateUsdPerMile,
            Optional<Double> fuelSurchargeRateUsdPerMile,
            Optional<Double> waitTimeBeforeChargeMinutes,
            Optional<Double> waitTimeRateUsdPerMinute,
            Optional<Double> extraStopRateUsd,
            Optional<Double> dangerousGoodsRateUsdPerInstance,
            Optional<Double> afterHours,
            Optional<Double> weekend,
            Optional<Double> holiday,
            Map<String, Object> additionalProperties) {
        this.name = name;
        this.cargoTypes = cargoTypes;
        this.vehicleTypes = vehicleTypes;
        this.routeTypes = routeTypes;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.comments = comments;
        this.baseMileageDistanceMiles = baseMileageDistanceMiles;
        this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
        this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
        this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
        this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
        this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
        this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
        this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
        this.extraStopRateUsd = extraStopRateUsd;
        this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
        this.afterHours = afterHours;
        this.weekend = weekend;
        this.holiday = holiday;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (name == null) {
            return Optional.empty();
        }
        return name;
    }

    @JsonIgnore
    public Optional<List<CargoTypeEnum1>> getCargoTypes() {
        if (cargoTypes == null) {
            return Optional.empty();
        }
        return cargoTypes;
    }

    @JsonIgnore
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        if (vehicleTypes == null) {
            return Optional.empty();
        }
        return vehicleTypes;
    }

    @JsonIgnore
    public Optional<List<RouteTypeEnum1>> getRouteTypes() {
        if (routeTypes == null) {
            return Optional.empty();
        }
        return routeTypes;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (shipperOrgId == null) {
            return Optional.empty();
        }
        return shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (comments == null) {
            return Optional.empty();
        }
        return comments;
    }

    @JsonIgnore
    public Optional<Double> getBaseMileageDistanceMiles() {
        if (baseMileageDistanceMiles == null) {
            return Optional.empty();
        }
        return baseMileageDistanceMiles;
    }

    @JsonIgnore
    public Optional<Double> getBaseMileageRateUsdPerInstance() {
        if (baseMileageRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return baseMileageRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getAdditionalMileageRateUsdPerMile() {
        if (additionalMileageRateUsdPerMile == null) {
            return Optional.empty();
        }
        return additionalMileageRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getLongDistanceSurchargeMilesBeforeSurcharge() {
        if (longDistanceSurchargeMilesBeforeSurcharge == null) {
            return Optional.empty();
        }
        return longDistanceSurchargeMilesBeforeSurcharge;
    }

    @JsonIgnore
    public Optional<Double> getLongDistanceSurchargeRateUsdPerMile() {
        if (longDistanceSurchargeRateUsdPerMile == null) {
            return Optional.empty();
        }
        return longDistanceSurchargeRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getFuelSurchargeRateUsdPerMile() {
        if (fuelSurchargeRateUsdPerMile == null) {
            return Optional.empty();
        }
        return fuelSurchargeRateUsdPerMile;
    }

    @JsonIgnore
    public Optional<Double> getWaitTimeBeforeChargeMinutes() {
        if (waitTimeBeforeChargeMinutes == null) {
            return Optional.empty();
        }
        return waitTimeBeforeChargeMinutes;
    }

    @JsonIgnore
    public Optional<Double> getWaitTimeRateUsdPerMinute() {
        if (waitTimeRateUsdPerMinute == null) {
            return Optional.empty();
        }
        return waitTimeRateUsdPerMinute;
    }

    @JsonIgnore
    public Optional<Double> getExtraStopRateUsd() {
        if (extraStopRateUsd == null) {
            return Optional.empty();
        }
        return extraStopRateUsd;
    }

    @JsonIgnore
    public Optional<Double> getDangerousGoodsRateUsdPerInstance() {
        if (dangerousGoodsRateUsdPerInstance == null) {
            return Optional.empty();
        }
        return dangerousGoodsRateUsdPerInstance;
    }

    @JsonIgnore
    public Optional<Double> getAfterHours() {
        if (afterHours == null) {
            return Optional.empty();
        }
        return afterHours;
    }

    @JsonIgnore
    public Optional<Double> getWeekend() {
        if (weekend == null) {
            return Optional.empty();
        }
        return weekend;
    }

    @JsonIgnore
    public Optional<Double> getHoliday() {
        if (holiday == null) {
            return Optional.empty();
        }
        return holiday;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("name")
    private Optional<String> _getName() {
        return name;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargo_types")
    private Optional<List<CargoTypeEnum1>> _getCargoTypes() {
        return cargoTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("vehicle_types")
    private Optional<List<VehicleTypeEnum>> _getVehicleTypes() {
        return vehicleTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("route_types")
    private Optional<List<RouteTypeEnum1>> _getRouteTypes() {
        return routeTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return shipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return offChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("comments")
    private Optional<String> _getComments() {
        return comments;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("base_mileage_distance_miles")
    private Optional<Double> _getBaseMileageDistanceMiles() {
        return baseMileageDistanceMiles;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("base_mileage_rate_usd_per_instance")
    private Optional<Double> _getBaseMileageRateUsdPerInstance() {
        return baseMileageRateUsdPerInstance;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("additional_mileage_rate_usd_per_mile")
    private Optional<Double> _getAdditionalMileageRateUsdPerMile() {
        return additionalMileageRateUsdPerMile;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("long_distance_surcharge_miles_before_surcharge")
    private Optional<Double> _getLongDistanceSurchargeMilesBeforeSurcharge() {
        return longDistanceSurchargeMilesBeforeSurcharge;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("long_distance_surcharge_rate_usd_per_mile")
    private Optional<Double> _getLongDistanceSurchargeRateUsdPerMile() {
        return longDistanceSurchargeRateUsdPerMile;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("fuel_surcharge_rate_usd_per_mile")
    private Optional<Double> _getFuelSurchargeRateUsdPerMile() {
        return fuelSurchargeRateUsdPerMile;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("wait_time_before_charge_minutes")
    private Optional<Double> _getWaitTimeBeforeChargeMinutes() {
        return waitTimeBeforeChargeMinutes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("wait_time_rate_usd_per_minute")
    private Optional<Double> _getWaitTimeRateUsdPerMinute() {
        return waitTimeRateUsdPerMinute;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("extra_stop_rate_usd")
    private Optional<Double> _getExtraStopRateUsd() {
        return extraStopRateUsd;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("dangerous_goods_rate_usd_per_instance")
    private Optional<Double> _getDangerousGoodsRateUsdPerInstance() {
        return dangerousGoodsRateUsdPerInstance;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("after_hours")
    private Optional<Double> _getAfterHours() {
        return afterHours;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("weekend")
    private Optional<Double> _getWeekend() {
        return weekend;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("holiday")
    private Optional<Double> _getHoliday() {
        return holiday;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShipperPayCourierRateSheetClientUpdate1
                && equalTo((ShipperPayCourierRateSheetClientUpdate1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperPayCourierRateSheetClientUpdate1 other) {
        return name.equals(other.name)
                && cargoTypes.equals(other.cargoTypes)
                && vehicleTypes.equals(other.vehicleTypes)
                && routeTypes.equals(other.routeTypes)
                && shipperOrgId.equals(other.shipperOrgId)
                && offChrtShipperOrgId.equals(other.offChrtShipperOrgId)
                && comments.equals(other.comments)
                && baseMileageDistanceMiles.equals(other.baseMileageDistanceMiles)
                && baseMileageRateUsdPerInstance.equals(other.baseMileageRateUsdPerInstance)
                && additionalMileageRateUsdPerMile.equals(other.additionalMileageRateUsdPerMile)
                && longDistanceSurchargeMilesBeforeSurcharge.equals(other.longDistanceSurchargeMilesBeforeSurcharge)
                && longDistanceSurchargeRateUsdPerMile.equals(other.longDistanceSurchargeRateUsdPerMile)
                && fuelSurchargeRateUsdPerMile.equals(other.fuelSurchargeRateUsdPerMile)
                && waitTimeBeforeChargeMinutes.equals(other.waitTimeBeforeChargeMinutes)
                && waitTimeRateUsdPerMinute.equals(other.waitTimeRateUsdPerMinute)
                && extraStopRateUsd.equals(other.extraStopRateUsd)
                && dangerousGoodsRateUsdPerInstance.equals(other.dangerousGoodsRateUsdPerInstance)
                && afterHours.equals(other.afterHours)
                && weekend.equals(other.weekend)
                && holiday.equals(other.holiday);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.name,
                this.cargoTypes,
                this.vehicleTypes,
                this.routeTypes,
                this.shipperOrgId,
                this.offChrtShipperOrgId,
                this.comments,
                this.baseMileageDistanceMiles,
                this.baseMileageRateUsdPerInstance,
                this.additionalMileageRateUsdPerMile,
                this.longDistanceSurchargeMilesBeforeSurcharge,
                this.longDistanceSurchargeRateUsdPerMile,
                this.fuelSurchargeRateUsdPerMile,
                this.waitTimeBeforeChargeMinutes,
                this.waitTimeRateUsdPerMinute,
                this.extraStopRateUsd,
                this.dangerousGoodsRateUsdPerInstance,
                this.afterHours,
                this.weekend,
                this.holiday);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();

        private Optional<List<CargoTypeEnum1>> cargoTypes = Optional.empty();

        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();

        private Optional<List<RouteTypeEnum1>> routeTypes = Optional.empty();

        private Optional<String> shipperOrgId = Optional.empty();

        private Optional<String> offChrtShipperOrgId = Optional.empty();

        private Optional<String> comments = Optional.empty();

        private Optional<Double> baseMileageDistanceMiles = Optional.empty();

        private Optional<Double> baseMileageRateUsdPerInstance = Optional.empty();

        private Optional<Double> additionalMileageRateUsdPerMile = Optional.empty();

        private Optional<Double> longDistanceSurchargeMilesBeforeSurcharge = Optional.empty();

        private Optional<Double> longDistanceSurchargeRateUsdPerMile = Optional.empty();

        private Optional<Double> fuelSurchargeRateUsdPerMile = Optional.empty();

        private Optional<Double> waitTimeBeforeChargeMinutes = Optional.empty();

        private Optional<Double> waitTimeRateUsdPerMinute = Optional.empty();

        private Optional<Double> extraStopRateUsd = Optional.empty();

        private Optional<Double> dangerousGoodsRateUsdPerInstance = Optional.empty();

        private Optional<Double> afterHours = Optional.empty();

        private Optional<Double> weekend = Optional.empty();

        private Optional<Double> holiday = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ShipperPayCourierRateSheetClientUpdate1 other) {
            name(other.getName());
            cargoTypes(other.getCargoTypes());
            vehicleTypes(other.getVehicleTypes());
            routeTypes(other.getRouteTypes());
            shipperOrgId(other.getShipperOrgId());
            offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            comments(other.getComments());
            baseMileageDistanceMiles(other.getBaseMileageDistanceMiles());
            baseMileageRateUsdPerInstance(other.getBaseMileageRateUsdPerInstance());
            additionalMileageRateUsdPerMile(other.getAdditionalMileageRateUsdPerMile());
            longDistanceSurchargeMilesBeforeSurcharge(other.getLongDistanceSurchargeMilesBeforeSurcharge());
            longDistanceSurchargeRateUsdPerMile(other.getLongDistanceSurchargeRateUsdPerMile());
            fuelSurchargeRateUsdPerMile(other.getFuelSurchargeRateUsdPerMile());
            waitTimeBeforeChargeMinutes(other.getWaitTimeBeforeChargeMinutes());
            waitTimeRateUsdPerMinute(other.getWaitTimeRateUsdPerMinute());
            extraStopRateUsd(other.getExtraStopRateUsd());
            dangerousGoodsRateUsdPerInstance(other.getDangerousGoodsRateUsdPerInstance());
            afterHours(other.getAfterHours());
            weekend(other.getWeekend());
            holiday(other.getHoliday());
            return this;
        }

        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            if (name.isNull()) {
                this.name = null;
            } else if (name.isEmpty()) {
                this.name = Optional.empty();
            } else {
                this.name = Optional.of(name.get());
            }
            return this;
        }

        @JsonSetter(value = "cargo_types", nulls = Nulls.SKIP)
        public Builder cargoTypes(Optional<List<CargoTypeEnum1>> cargoTypes) {
            this.cargoTypes = cargoTypes;
            return this;
        }

        public Builder cargoTypes(List<CargoTypeEnum1> cargoTypes) {
            this.cargoTypes = Optional.ofNullable(cargoTypes);
            return this;
        }

        public Builder cargoTypes(Nullable<List<CargoTypeEnum1>> cargoTypes) {
            if (cargoTypes.isNull()) {
                this.cargoTypes = null;
            } else if (cargoTypes.isEmpty()) {
                this.cargoTypes = Optional.empty();
            } else {
                this.cargoTypes = Optional.of(cargoTypes.get());
            }
            return this;
        }

        @JsonSetter(value = "vehicle_types", nulls = Nulls.SKIP)
        public Builder vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        public Builder vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        public Builder vehicleTypes(Nullable<List<VehicleTypeEnum>> vehicleTypes) {
            if (vehicleTypes.isNull()) {
                this.vehicleTypes = null;
            } else if (vehicleTypes.isEmpty()) {
                this.vehicleTypes = Optional.empty();
            } else {
                this.vehicleTypes = Optional.of(vehicleTypes.get());
            }
            return this;
        }

        @JsonSetter(value = "route_types", nulls = Nulls.SKIP)
        public Builder routeTypes(Optional<List<RouteTypeEnum1>> routeTypes) {
            this.routeTypes = routeTypes;
            return this;
        }

        public Builder routeTypes(List<RouteTypeEnum1> routeTypes) {
            this.routeTypes = Optional.ofNullable(routeTypes);
            return this;
        }

        public Builder routeTypes(Nullable<List<RouteTypeEnum1>> routeTypes) {
            if (routeTypes.isNull()) {
                this.routeTypes = null;
            } else if (routeTypes.isEmpty()) {
                this.routeTypes = Optional.empty();
            } else {
                this.routeTypes = Optional.of(routeTypes.get());
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @JsonSetter(value = "shipper_org_id", nulls = Nulls.SKIP)
        public Builder shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        public Builder shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        public Builder shipperOrgId(Nullable<String> shipperOrgId) {
            if (shipperOrgId.isNull()) {
                this.shipperOrgId = null;
            } else if (shipperOrgId.isEmpty()) {
                this.shipperOrgId = Optional.empty();
            } else {
                this.shipperOrgId = Optional.of(shipperOrgId.get());
            }
            return this;
        }

        @JsonSetter(value = "off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public Builder offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        public Builder offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        public Builder offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            if (offChrtShipperOrgId.isNull()) {
                this.offChrtShipperOrgId = null;
            } else if (offChrtShipperOrgId.isEmpty()) {
                this.offChrtShipperOrgId = Optional.empty();
            } else {
                this.offChrtShipperOrgId = Optional.of(offChrtShipperOrgId.get());
            }
            return this;
        }

        @JsonSetter(value = "comments", nulls = Nulls.SKIP)
        public Builder comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        public Builder comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        public Builder comments(Nullable<String> comments) {
            if (comments.isNull()) {
                this.comments = null;
            } else if (comments.isEmpty()) {
                this.comments = Optional.empty();
            } else {
                this.comments = Optional.of(comments.get());
            }
            return this;
        }

        @JsonSetter(value = "base_mileage_distance_miles", nulls = Nulls.SKIP)
        public Builder baseMileageDistanceMiles(Optional<Double> baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = baseMileageDistanceMiles;
            return this;
        }

        public Builder baseMileageDistanceMiles(Double baseMileageDistanceMiles) {
            this.baseMileageDistanceMiles = Optional.ofNullable(baseMileageDistanceMiles);
            return this;
        }

        public Builder baseMileageDistanceMiles(Nullable<Double> baseMileageDistanceMiles) {
            if (baseMileageDistanceMiles.isNull()) {
                this.baseMileageDistanceMiles = null;
            } else if (baseMileageDistanceMiles.isEmpty()) {
                this.baseMileageDistanceMiles = Optional.empty();
            } else {
                this.baseMileageDistanceMiles = Optional.of(baseMileageDistanceMiles.get());
            }
            return this;
        }

        @JsonSetter(value = "base_mileage_rate_usd_per_instance", nulls = Nulls.SKIP)
        public Builder baseMileageRateUsdPerInstance(Optional<Double> baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = baseMileageRateUsdPerInstance;
            return this;
        }

        public Builder baseMileageRateUsdPerInstance(Double baseMileageRateUsdPerInstance) {
            this.baseMileageRateUsdPerInstance = Optional.ofNullable(baseMileageRateUsdPerInstance);
            return this;
        }

        public Builder baseMileageRateUsdPerInstance(Nullable<Double> baseMileageRateUsdPerInstance) {
            if (baseMileageRateUsdPerInstance.isNull()) {
                this.baseMileageRateUsdPerInstance = null;
            } else if (baseMileageRateUsdPerInstance.isEmpty()) {
                this.baseMileageRateUsdPerInstance = Optional.empty();
            } else {
                this.baseMileageRateUsdPerInstance = Optional.of(baseMileageRateUsdPerInstance.get());
            }
            return this;
        }

        @JsonSetter(value = "additional_mileage_rate_usd_per_mile", nulls = Nulls.SKIP)
        public Builder additionalMileageRateUsdPerMile(Optional<Double> additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = additionalMileageRateUsdPerMile;
            return this;
        }

        public Builder additionalMileageRateUsdPerMile(Double additionalMileageRateUsdPerMile) {
            this.additionalMileageRateUsdPerMile = Optional.ofNullable(additionalMileageRateUsdPerMile);
            return this;
        }

        public Builder additionalMileageRateUsdPerMile(Nullable<Double> additionalMileageRateUsdPerMile) {
            if (additionalMileageRateUsdPerMile.isNull()) {
                this.additionalMileageRateUsdPerMile = null;
            } else if (additionalMileageRateUsdPerMile.isEmpty()) {
                this.additionalMileageRateUsdPerMile = Optional.empty();
            } else {
                this.additionalMileageRateUsdPerMile = Optional.of(additionalMileageRateUsdPerMile.get());
            }
            return this;
        }

        @JsonSetter(value = "long_distance_surcharge_miles_before_surcharge", nulls = Nulls.SKIP)
        public Builder longDistanceSurchargeMilesBeforeSurcharge(
                Optional<Double> longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge = longDistanceSurchargeMilesBeforeSurcharge;
            return this;
        }

        public Builder longDistanceSurchargeMilesBeforeSurcharge(Double longDistanceSurchargeMilesBeforeSurcharge) {
            this.longDistanceSurchargeMilesBeforeSurcharge =
                    Optional.ofNullable(longDistanceSurchargeMilesBeforeSurcharge);
            return this;
        }

        public Builder longDistanceSurchargeMilesBeforeSurcharge(
                Nullable<Double> longDistanceSurchargeMilesBeforeSurcharge) {
            if (longDistanceSurchargeMilesBeforeSurcharge.isNull()) {
                this.longDistanceSurchargeMilesBeforeSurcharge = null;
            } else if (longDistanceSurchargeMilesBeforeSurcharge.isEmpty()) {
                this.longDistanceSurchargeMilesBeforeSurcharge = Optional.empty();
            } else {
                this.longDistanceSurchargeMilesBeforeSurcharge =
                        Optional.of(longDistanceSurchargeMilesBeforeSurcharge.get());
            }
            return this;
        }

        @JsonSetter(value = "long_distance_surcharge_rate_usd_per_mile", nulls = Nulls.SKIP)
        public Builder longDistanceSurchargeRateUsdPerMile(Optional<Double> longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = longDistanceSurchargeRateUsdPerMile;
            return this;
        }

        public Builder longDistanceSurchargeRateUsdPerMile(Double longDistanceSurchargeRateUsdPerMile) {
            this.longDistanceSurchargeRateUsdPerMile = Optional.ofNullable(longDistanceSurchargeRateUsdPerMile);
            return this;
        }

        public Builder longDistanceSurchargeRateUsdPerMile(Nullable<Double> longDistanceSurchargeRateUsdPerMile) {
            if (longDistanceSurchargeRateUsdPerMile.isNull()) {
                this.longDistanceSurchargeRateUsdPerMile = null;
            } else if (longDistanceSurchargeRateUsdPerMile.isEmpty()) {
                this.longDistanceSurchargeRateUsdPerMile = Optional.empty();
            } else {
                this.longDistanceSurchargeRateUsdPerMile = Optional.of(longDistanceSurchargeRateUsdPerMile.get());
            }
            return this;
        }

        @JsonSetter(value = "fuel_surcharge_rate_usd_per_mile", nulls = Nulls.SKIP)
        public Builder fuelSurchargeRateUsdPerMile(Optional<Double> fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = fuelSurchargeRateUsdPerMile;
            return this;
        }

        public Builder fuelSurchargeRateUsdPerMile(Double fuelSurchargeRateUsdPerMile) {
            this.fuelSurchargeRateUsdPerMile = Optional.ofNullable(fuelSurchargeRateUsdPerMile);
            return this;
        }

        public Builder fuelSurchargeRateUsdPerMile(Nullable<Double> fuelSurchargeRateUsdPerMile) {
            if (fuelSurchargeRateUsdPerMile.isNull()) {
                this.fuelSurchargeRateUsdPerMile = null;
            } else if (fuelSurchargeRateUsdPerMile.isEmpty()) {
                this.fuelSurchargeRateUsdPerMile = Optional.empty();
            } else {
                this.fuelSurchargeRateUsdPerMile = Optional.of(fuelSurchargeRateUsdPerMile.get());
            }
            return this;
        }

        @JsonSetter(value = "wait_time_before_charge_minutes", nulls = Nulls.SKIP)
        public Builder waitTimeBeforeChargeMinutes(Optional<Double> waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = waitTimeBeforeChargeMinutes;
            return this;
        }

        public Builder waitTimeBeforeChargeMinutes(Double waitTimeBeforeChargeMinutes) {
            this.waitTimeBeforeChargeMinutes = Optional.ofNullable(waitTimeBeforeChargeMinutes);
            return this;
        }

        public Builder waitTimeBeforeChargeMinutes(Nullable<Double> waitTimeBeforeChargeMinutes) {
            if (waitTimeBeforeChargeMinutes.isNull()) {
                this.waitTimeBeforeChargeMinutes = null;
            } else if (waitTimeBeforeChargeMinutes.isEmpty()) {
                this.waitTimeBeforeChargeMinutes = Optional.empty();
            } else {
                this.waitTimeBeforeChargeMinutes = Optional.of(waitTimeBeforeChargeMinutes.get());
            }
            return this;
        }

        @JsonSetter(value = "wait_time_rate_usd_per_minute", nulls = Nulls.SKIP)
        public Builder waitTimeRateUsdPerMinute(Optional<Double> waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = waitTimeRateUsdPerMinute;
            return this;
        }

        public Builder waitTimeRateUsdPerMinute(Double waitTimeRateUsdPerMinute) {
            this.waitTimeRateUsdPerMinute = Optional.ofNullable(waitTimeRateUsdPerMinute);
            return this;
        }

        public Builder waitTimeRateUsdPerMinute(Nullable<Double> waitTimeRateUsdPerMinute) {
            if (waitTimeRateUsdPerMinute.isNull()) {
                this.waitTimeRateUsdPerMinute = null;
            } else if (waitTimeRateUsdPerMinute.isEmpty()) {
                this.waitTimeRateUsdPerMinute = Optional.empty();
            } else {
                this.waitTimeRateUsdPerMinute = Optional.of(waitTimeRateUsdPerMinute.get());
            }
            return this;
        }

        @JsonSetter(value = "extra_stop_rate_usd", nulls = Nulls.SKIP)
        public Builder extraStopRateUsd(Optional<Double> extraStopRateUsd) {
            this.extraStopRateUsd = extraStopRateUsd;
            return this;
        }

        public Builder extraStopRateUsd(Double extraStopRateUsd) {
            this.extraStopRateUsd = Optional.ofNullable(extraStopRateUsd);
            return this;
        }

        public Builder extraStopRateUsd(Nullable<Double> extraStopRateUsd) {
            if (extraStopRateUsd.isNull()) {
                this.extraStopRateUsd = null;
            } else if (extraStopRateUsd.isEmpty()) {
                this.extraStopRateUsd = Optional.empty();
            } else {
                this.extraStopRateUsd = Optional.of(extraStopRateUsd.get());
            }
            return this;
        }

        @JsonSetter(value = "dangerous_goods_rate_usd_per_instance", nulls = Nulls.SKIP)
        public Builder dangerousGoodsRateUsdPerInstance(Optional<Double> dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = dangerousGoodsRateUsdPerInstance;
            return this;
        }

        public Builder dangerousGoodsRateUsdPerInstance(Double dangerousGoodsRateUsdPerInstance) {
            this.dangerousGoodsRateUsdPerInstance = Optional.ofNullable(dangerousGoodsRateUsdPerInstance);
            return this;
        }

        public Builder dangerousGoodsRateUsdPerInstance(Nullable<Double> dangerousGoodsRateUsdPerInstance) {
            if (dangerousGoodsRateUsdPerInstance.isNull()) {
                this.dangerousGoodsRateUsdPerInstance = null;
            } else if (dangerousGoodsRateUsdPerInstance.isEmpty()) {
                this.dangerousGoodsRateUsdPerInstance = Optional.empty();
            } else {
                this.dangerousGoodsRateUsdPerInstance = Optional.of(dangerousGoodsRateUsdPerInstance.get());
            }
            return this;
        }

        @JsonSetter(value = "after_hours", nulls = Nulls.SKIP)
        public Builder afterHours(Optional<Double> afterHours) {
            this.afterHours = afterHours;
            return this;
        }

        public Builder afterHours(Double afterHours) {
            this.afterHours = Optional.ofNullable(afterHours);
            return this;
        }

        public Builder afterHours(Nullable<Double> afterHours) {
            if (afterHours.isNull()) {
                this.afterHours = null;
            } else if (afterHours.isEmpty()) {
                this.afterHours = Optional.empty();
            } else {
                this.afterHours = Optional.of(afterHours.get());
            }
            return this;
        }

        @JsonSetter(value = "weekend", nulls = Nulls.SKIP)
        public Builder weekend(Optional<Double> weekend) {
            this.weekend = weekend;
            return this;
        }

        public Builder weekend(Double weekend) {
            this.weekend = Optional.ofNullable(weekend);
            return this;
        }

        public Builder weekend(Nullable<Double> weekend) {
            if (weekend.isNull()) {
                this.weekend = null;
            } else if (weekend.isEmpty()) {
                this.weekend = Optional.empty();
            } else {
                this.weekend = Optional.of(weekend.get());
            }
            return this;
        }

        @JsonSetter(value = "holiday", nulls = Nulls.SKIP)
        public Builder holiday(Optional<Double> holiday) {
            this.holiday = holiday;
            return this;
        }

        public Builder holiday(Double holiday) {
            this.holiday = Optional.ofNullable(holiday);
            return this;
        }

        public Builder holiday(Nullable<Double> holiday) {
            if (holiday.isNull()) {
                this.holiday = null;
            } else if (holiday.isEmpty()) {
                this.holiday = Optional.empty();
            } else {
                this.holiday = Optional.of(holiday.get());
            }
            return this;
        }

        public ShipperPayCourierRateSheetClientUpdate1 build() {
            return new ShipperPayCourierRateSheetClientUpdate1(
                    name,
                    cargoTypes,
                    vehicleTypes,
                    routeTypes,
                    shipperOrgId,
                    offChrtShipperOrgId,
                    comments,
                    baseMileageDistanceMiles,
                    baseMileageRateUsdPerInstance,
                    additionalMileageRateUsdPerMile,
                    longDistanceSurchargeMilesBeforeSurcharge,
                    longDistanceSurchargeRateUsdPerMile,
                    fuelSurchargeRateUsdPerMile,
                    waitTimeBeforeChargeMinutes,
                    waitTimeRateUsdPerMinute,
                    extraStopRateUsd,
                    dangerousGoodsRateUsdPerInstance,
                    afterHours,
                    weekend,
                    holiday,
                    additionalProperties);
        }
    }
}
