/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierstatements;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.shipperpaycourierstatements.requests.ListStatementsByCourierReq;
import com.chrt.api.resources.shipperpaycourierstatements.requests.ListStatementsByShipperReq;
import com.chrt.api.types.CreateShipperPayCourierStatementReq;
import com.chrt.api.types.GetShipperPayCourierStatementsForShipperRes;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.ShipperPayCourierStatement1;
import com.chrt.api.types.StatementPreviewResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawShipperPayCourierStatementsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawShipperPayCourierStatementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Retrieves a shipper pay courier statement by its ID with Stripe invoice sync. | () -&gt; (ShipperPayCourierStatement1)
     */
    public CompletableFuture<ChrtApiHttpResponse<ShipperPayCourierStatement1>> getByIdV1(
            String shipperPayCourierStatementId) {
        return getByIdV1(shipperPayCourierStatementId, null);
    }

    /**
     * Retrieves a shipper pay courier statement by its ID with Stripe invoice sync. | () -&gt; (ShipperPayCourierStatement1)
     */
    public CompletableFuture<ChrtApiHttpResponse<ShipperPayCourierStatement1>> getByIdV1(
            String shipperPayCourierStatementId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/shipper_pay_courier_statements/v1")
                .addPathSegment(shipperPayCourierStatementId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<ShipperPayCourierStatement1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, ShipperPayCourierStatement1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Deletes a shipper-to-courier statement record if invoice not yet created. | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> deleteV1(String shipperPayCourierStatementId) {
        return deleteV1(shipperPayCourierStatementId, null);
    }

    /**
     * Deletes a shipper-to-courier statement record if invoice not yet created. | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> deleteV1(
            String shipperPayCourierStatementId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/shipper_pay_courier_statements/v1")
                .addPathSegment(shipperPayCourierStatementId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Retrieves a shipper pay courier statement by order ID or short ID with Stripe invoice sync. | () -&gt; (ShipperPayCourierStatement1)
     */
    public CompletableFuture<ChrtApiHttpResponse<ShipperPayCourierStatement1>> getByOrderIdOrShortIdV1(
            String orderIdOrShortId) {
        return getByOrderIdOrShortIdV1(orderIdOrShortId, null);
    }

    /**
     * Retrieves a shipper pay courier statement by order ID or short ID with Stripe invoice sync. | () -&gt; (ShipperPayCourierStatement1)
     */
    public CompletableFuture<ChrtApiHttpResponse<ShipperPayCourierStatement1>> getByOrderIdOrShortIdV1(
            String orderIdOrShortId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/shipper_pay_courier_statements/by_order/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<ShipperPayCourierStatement1>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, ShipperPayCourierStatement1.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Lists shipper pay courier statements by shipper org ID with status filtering and Stripe sync. | (ListStatementsByShipperReq) -&gt; (GetShipperPayCourierStatementsForShipperRes)
     */
    public CompletableFuture<ChrtApiHttpResponse<GetShipperPayCourierStatementsForShipperRes>> listByShipperOrgIdV1(
            ListStatementsByShipperReq request) {
        return listByShipperOrgIdV1(request, null);
    }

    /**
     * Lists shipper pay courier statements by shipper org ID with status filtering and Stripe sync. | (ListStatementsByShipperReq) -&gt; (GetShipperPayCourierStatementsForShipperRes)
     */
    public CompletableFuture<ChrtApiHttpResponse<GetShipperPayCourierStatementsForShipperRes>> listByShipperOrgIdV1(
            ListStatementsByShipperReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/shipper_pay_courier_statements/list/by_shipper_org_id/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<GetShipperPayCourierStatementsForShipperRes>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, GetShipperPayCourierStatementsForShipperRes.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Lists shipper pay courier statements by courier org ID with status filtering and Stripe sync. | (ListStatementsByCourierReq) -&gt; (GetShipperPayCourierStatementsForShipperRes)
     */
    public CompletableFuture<ChrtApiHttpResponse<GetShipperPayCourierStatementsForShipperRes>> listByCourierOrgIdV1(
            ListStatementsByCourierReq request) {
        return listByCourierOrgIdV1(request, null);
    }

    /**
     * Lists shipper pay courier statements by courier org ID with status filtering and Stripe sync. | (ListStatementsByCourierReq) -&gt; (GetShipperPayCourierStatementsForShipperRes)
     */
    public CompletableFuture<ChrtApiHttpResponse<GetShipperPayCourierStatementsForShipperRes>> listByCourierOrgIdV1(
            ListStatementsByCourierReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/shipper_pay_courier_statements/list/by_courier_org_id/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<GetShipperPayCourierStatementsForShipperRes>> future =
                new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, GetShipperPayCourierStatementsForShipperRes.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Creates a shipper-to-courier statement record based on all task groups in an order. | (CreateShipperPayCourierStatementReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<ChrtApiHttpResponse<String>> createV1(CreateShipperPayCourierStatementReq request) {
        return createV1(request, null);
    }

    /**
     * Creates a shipper-to-courier statement record based on all task groups in an order. | (CreateShipperPayCourierStatementReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<ChrtApiHttpResponse<String>> createV1(
            CreateShipperPayCourierStatementReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/shipper_pay_courier_statements/create/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<String>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Previews a shipper-to-courier statement showing task groups, line item groups, total amount, and readiness status. | (CreateShipperPayCourierStatementReq) -&gt; (StatementPreviewResponse)
     */
    public CompletableFuture<ChrtApiHttpResponse<StatementPreviewResponse>> previewV1(
            CreateShipperPayCourierStatementReq request) {
        return previewV1(request, null);
    }

    /**
     * Previews a shipper-to-courier statement showing task groups, line item groups, total amount, and readiness status. | (CreateShipperPayCourierStatementReq) -&gt; (StatementPreviewResponse)
     */
    public CompletableFuture<ChrtApiHttpResponse<StatementPreviewResponse>> previewV1(
            CreateShipperPayCourierStatementReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/shipper_pay_courier_statements/preview/v1")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<StatementPreviewResponse>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, StatementPreviewResponse.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
