/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifacts.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TaskArtifactClientCreate1;
import com.chrt.api.types.TaskArtifactStatusEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AddTaskArtifactReq.Builder.class)
public final class AddTaskArtifactReq {
    private final TaskArtifactClientCreate1 taskArtifact;

    private final TaskArtifactStatusEnum1 status;

    private final Map<String, Object> additionalProperties;

    private AddTaskArtifactReq(
            TaskArtifactClientCreate1 taskArtifact,
            TaskArtifactStatusEnum1 status,
            Map<String, Object> additionalProperties) {
        this.taskArtifact = taskArtifact;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_artifact")
    public TaskArtifactClientCreate1 getTaskArtifact() {
        return taskArtifact;
    }

    /**
     * @return Initial status of the task artifact.
     */
    @JsonProperty("status")
    public TaskArtifactStatusEnum1 getStatus() {
        return status;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AddTaskArtifactReq && equalTo((AddTaskArtifactReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AddTaskArtifactReq other) {
        return taskArtifact.equals(other.taskArtifact) && status.equals(other.status);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.taskArtifact, this.status);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskArtifactStage builder() {
        return new Builder();
    }

    public interface TaskArtifactStage {
        StatusStage taskArtifact(@NotNull TaskArtifactClientCreate1 taskArtifact);

        Builder from(AddTaskArtifactReq other);
    }

    public interface StatusStage {
        /**
         * <p>Initial status of the task artifact.</p>
         */
        _FinalStage status(@NotNull TaskArtifactStatusEnum1 status);
    }

    public interface _FinalStage {
        AddTaskArtifactReq build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskArtifactStage, StatusStage, _FinalStage {
        private TaskArtifactClientCreate1 taskArtifact;

        private TaskArtifactStatusEnum1 status;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AddTaskArtifactReq other) {
            taskArtifact(other.getTaskArtifact());
            status(other.getStatus());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_artifact")
        public StatusStage taskArtifact(@NotNull TaskArtifactClientCreate1 taskArtifact) {
            this.taskArtifact = Objects.requireNonNull(taskArtifact, "taskArtifact must not be null");
            return this;
        }

        /**
         * <p>Initial status of the task artifact.</p>
         * <p>Initial status of the task artifact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("status")
        public _FinalStage status(@NotNull TaskArtifactStatusEnum1 status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @java.lang.Override
        public AddTaskArtifactReq build() {
            return new AddTaskArtifactReq(taskArtifact, status, additionalProperties);
        }
    }
}
