/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskgroups.expanded.ExpandedClient;
import com.chrt.api.resources.taskgroups.requests.AddMessageReq;
import com.chrt.api.resources.taskgroups.requests.SetFlightNumberReq;
import com.chrt.api.resources.taskgroups.requests.SetTaskOrderingReq;
import com.chrt.api.resources.taskgroups.requests.UpdateCourierOrgReq;
import com.chrt.api.resources.taskgroups.requests.UpdateDriverReq;
import com.chrt.api.resources.taskgroups.s3object.S3ObjectClient;
import com.chrt.api.resources.taskgroups.taskgroupid.TaskGroupIdClient;
import java.util.function.Supplier;

public class TaskGroupsClient {
    protected final ClientOptions clientOptions;

    private final RawTaskGroupsClient rawClient;

    protected final Supplier<TaskGroupIdClient> taskGroupIdClient;

    protected final Supplier<S3ObjectClient> s3ObjectClient;

    protected final Supplier<ExpandedClient> expandedClient;

    public TaskGroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskGroupsClient(clientOptions);
        this.taskGroupIdClient = Suppliers.memoize(() -> new TaskGroupIdClient(clientOptions));
        this.s3ObjectClient = Suppliers.memoize(() -> new S3ObjectClient(clientOptions));
        this.expandedClient = Suppliers.memoize(() -> new ExpandedClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTaskGroupsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Starts a task group by transitioning it from STAGED to IN_PROGRESS and syncing related order state. | authz_personas=[courier_driver, lig_org_operators] | () -&gt; (bool)
     */
    public boolean startV1(String taskGroupId) {
        return this.rawClient.startV1(taskGroupId).body();
    }

    /**
     * Starts a task group by transitioning it from STAGED to IN_PROGRESS and syncing related order state. | authz_personas=[courier_driver, lig_org_operators] | () -&gt; (bool)
     */
    public boolean startV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.startV1(taskGroupId, requestOptions).body();
    }

    /**
     * Sets the ordering of tasks within a task group. Requires complete list of task IDs in desired order. Completed tasks must be before staged tasks. | authz_personas=[lig_org_operators] | (SetTaskOrderingReq) -&gt; (bool)
     */
    public boolean setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request) {
        return this.rawClient.setTaskOrderingV1(taskGroupId, request).body();
    }

    /**
     * Sets the ordering of tasks within a task group. Requires complete list of task IDs in desired order. Completed tasks must be before staged tasks. | authz_personas=[lig_org_operators] | (SetTaskOrderingReq) -&gt; (bool)
     */
    public boolean setTaskOrderingV1(String taskGroupId, SetTaskOrderingReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setTaskOrderingV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Sets the flight number on a task group, plus any TENDER_TO_AIRLINE tasks in the immediately preceding task group and RECOVER_FROM_AIRLINE tasks in the immediately following task group. | authz_personas=[lig_org_operators] | (SetFlightNumberReq) -&gt; (bool)
     */
    public boolean setFlightNumberV1(String taskGroupId, SetFlightNumberReq request) {
        return this.rawClient.setFlightNumberV1(taskGroupId, request).body();
    }

    /**
     * Sets the flight number on a task group, plus any TENDER_TO_AIRLINE tasks in the immediately preceding task group and RECOVER_FROM_AIRLINE tasks in the immediately following task group. | authz_personas=[lig_org_operators] | (SetFlightNumberReq) -&gt; (bool)
     */
    public boolean setFlightNumberV1(String taskGroupId, SetFlightNumberReq request, RequestOptions requestOptions) {
        return this.rawClient
                .setFlightNumberV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Updates the driver assigned to a task group. | authz_personas=[courier_org_operators] | (UpdateDriverReq) -&gt; (bool)
     */
    public boolean updateDriverV1(String taskGroupId, UpdateDriverReq request) {
        return this.rawClient.updateDriverV1(taskGroupId, request).body();
    }

    /**
     * Updates the driver assigned to a task group. | authz_personas=[courier_org_operators] | (UpdateDriverReq) -&gt; (bool)
     */
    public boolean updateDriverV1(String taskGroupId, UpdateDriverReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateDriverV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Removes the driver from a task group (sets driver_id to null). | authz_personas=[courier_org_operators, courier_driver] | () -&gt; (bool)
     */
    public boolean removeDriverV1(String taskGroupId) {
        return this.rawClient.removeDriverV1(taskGroupId).body();
    }

    /**
     * Removes the driver from a task group (sets driver_id to null). | authz_personas=[courier_org_operators, courier_driver] | () -&gt; (bool)
     */
    public boolean removeDriverV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.removeDriverV1(taskGroupId, requestOptions).body();
    }

    /**
     * Updates the courier organization assigned to a task group. | authz_personas=[forwarder_org_operators] | (UpdateCourierOrgReq) -&gt; (bool)
     */
    public boolean updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request) {
        return this.rawClient.updateCourierOrgV1(taskGroupId, request).body();
    }

    /**
     * Updates the courier organization assigned to a task group. | authz_personas=[forwarder_org_operators] | (UpdateCourierOrgReq) -&gt; (bool)
     */
    public boolean updateCourierOrgV1(String taskGroupId, UpdateCourierOrgReq request, RequestOptions requestOptions) {
        return this.rawClient
                .updateCourierOrgV1(taskGroupId, request, requestOptions)
                .body();
    }

    /**
     * Adds a message to a task group's message log. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators, shipper_org_operators] | (AddMessageReq) -&gt; (bool)
     */
    public boolean addMessageV1(String taskGroupId, AddMessageReq request) {
        return this.rawClient.addMessageV1(taskGroupId, request).body();
    }

    /**
     * Adds a message to a task group's message log. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators, shipper_org_operators] | (AddMessageReq) -&gt; (bool)
     */
    public boolean addMessageV1(String taskGroupId, AddMessageReq request, RequestOptions requestOptions) {
        return this.rawClient.addMessageV1(taskGroupId, request, requestOptions).body();
    }

    public TaskGroupIdClient taskGroupId() {
        return this.taskGroupIdClient.get();
    }

    public S3ObjectClient s3Object() {
        return this.s3ObjectClient.get();
    }

    public ExpandedClient expanded() {
        return this.expandedClient.get();
    }
}
