/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.expanded.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.resources.taskgroups.expanded.types.ExpandedListForCourierDriverV1RequestSortOrder;
import com.chrt.api.types.OrderAndTaskGroupExpandedReq;
import com.chrt.api.types.TaskGroupSortByEnum;
import com.chrt.api.types.TaskGroupStatusEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ExpandedListForCourierDriverV1Request.Builder.class)
public final class ExpandedListForCourierDriverV1Request {
    private final Optional<List<TaskGroupStatusEnum1>> filterStatus;

    private final Optional<TaskGroupSortByEnum> sortBy;

    private final Optional<ExpandedListForCourierDriverV1RequestSortOrder> sortOrder;

    private final Optional<Integer> page;

    private final Optional<Integer> pageSize;

    private final Optional<OffsetDateTime> filterDraftStartedAtTimestampLte;

    private final Optional<OffsetDateTime> filterDraftStartedAtTimestampGte;

    private final Optional<OffsetDateTime> filterStagedAtTimestampLte;

    private final Optional<OffsetDateTime> filterStagedAtTimestampGte;

    private final Optional<OffsetDateTime> filterInProgressAtTimestampLte;

    private final Optional<OffsetDateTime> filterInProgressAtTimestampGte;

    private final Optional<OffsetDateTime> filterCompletedAtTimestampLte;

    private final Optional<OffsetDateTime> filterCompletedAtTimestampGte;

    private final Optional<OffsetDateTime> filterSkippedAtTimestampLte;

    private final Optional<OffsetDateTime> filterSkippedAtTimestampGte;

    private final Optional<OffsetDateTime> filterExceptionAtTimestampLte;

    private final Optional<OffsetDateTime> filterExceptionAtTimestampGte;

    private final OrderAndTaskGroupExpandedReq body;

    private final Map<String, Object> additionalProperties;

    private ExpandedListForCourierDriverV1Request(
            Optional<List<TaskGroupStatusEnum1>> filterStatus,
            Optional<TaskGroupSortByEnum> sortBy,
            Optional<ExpandedListForCourierDriverV1RequestSortOrder> sortOrder,
            Optional<Integer> page,
            Optional<Integer> pageSize,
            Optional<OffsetDateTime> filterDraftStartedAtTimestampLte,
            Optional<OffsetDateTime> filterDraftStartedAtTimestampGte,
            Optional<OffsetDateTime> filterStagedAtTimestampLte,
            Optional<OffsetDateTime> filterStagedAtTimestampGte,
            Optional<OffsetDateTime> filterInProgressAtTimestampLte,
            Optional<OffsetDateTime> filterInProgressAtTimestampGte,
            Optional<OffsetDateTime> filterCompletedAtTimestampLte,
            Optional<OffsetDateTime> filterCompletedAtTimestampGte,
            Optional<OffsetDateTime> filterSkippedAtTimestampLte,
            Optional<OffsetDateTime> filterSkippedAtTimestampGte,
            Optional<OffsetDateTime> filterExceptionAtTimestampLte,
            Optional<OffsetDateTime> filterExceptionAtTimestampGte,
            OrderAndTaskGroupExpandedReq body,
            Map<String, Object> additionalProperties) {
        this.filterStatus = filterStatus;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.page = page;
        this.pageSize = pageSize;
        this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte;
        this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte;
        this.filterStagedAtTimestampLte = filterStagedAtTimestampLte;
        this.filterStagedAtTimestampGte = filterStagedAtTimestampGte;
        this.filterInProgressAtTimestampLte = filterInProgressAtTimestampLte;
        this.filterInProgressAtTimestampGte = filterInProgressAtTimestampGte;
        this.filterCompletedAtTimestampLte = filterCompletedAtTimestampLte;
        this.filterCompletedAtTimestampGte = filterCompletedAtTimestampGte;
        this.filterSkippedAtTimestampLte = filterSkippedAtTimestampLte;
        this.filterSkippedAtTimestampGte = filterSkippedAtTimestampGte;
        this.filterExceptionAtTimestampLte = filterExceptionAtTimestampLte;
        this.filterExceptionAtTimestampGte = filterExceptionAtTimestampGte;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<TaskGroupStatusEnum1>> getFilterStatus() {
        if (filterStatus == null) {
            return Optional.empty();
        }
        return filterStatus;
    }

    @JsonIgnore
    public Optional<TaskGroupSortByEnum> getSortBy() {
        if (sortBy == null) {
            return Optional.empty();
        }
        return sortBy;
    }

    @JsonIgnore
    public Optional<ExpandedListForCourierDriverV1RequestSortOrder> getSortOrder() {
        if (sortOrder == null) {
            return Optional.empty();
        }
        return sortOrder;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (page == null) {
            return Optional.empty();
        }
        return page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (pageSize == null) {
            return Optional.empty();
        }
        return pageSize;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtTimestampLte() {
        if (filterDraftStartedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterDraftStartedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtTimestampGte() {
        if (filterDraftStartedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterDraftStartedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStagedAtTimestampLte() {
        if (filterStagedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterStagedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterStagedAtTimestampGte() {
        if (filterStagedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterStagedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterInProgressAtTimestampLte() {
        if (filterInProgressAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterInProgressAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterInProgressAtTimestampGte() {
        if (filterInProgressAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterInProgressAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterCompletedAtTimestampLte() {
        if (filterCompletedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterCompletedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterCompletedAtTimestampGte() {
        if (filterCompletedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterCompletedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterSkippedAtTimestampLte() {
        if (filterSkippedAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterSkippedAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterSkippedAtTimestampGte() {
        if (filterSkippedAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterSkippedAtTimestampGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterExceptionAtTimestampLte() {
        if (filterExceptionAtTimestampLte == null) {
            return Optional.empty();
        }
        return filterExceptionAtTimestampLte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterExceptionAtTimestampGte() {
        if (filterExceptionAtTimestampGte == null) {
            return Optional.empty();
        }
        return filterExceptionAtTimestampGte;
    }

    @JsonProperty("body")
    public OrderAndTaskGroupExpandedReq getBody() {
        return body;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_status")
    private Optional<List<TaskGroupStatusEnum1>> _getFilterStatus() {
        return filterStatus;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_by")
    private Optional<TaskGroupSortByEnum> _getSortBy() {
        return sortBy;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_order")
    private Optional<ExpandedListForCourierDriverV1RequestSortOrder> _getSortOrder() {
        return sortOrder;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page")
    private Optional<Integer> _getPage() {
        return page;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page_size")
    private Optional<Integer> _getPageSize() {
        return pageSize;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_draft_started_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtTimestampLte() {
        return filterDraftStartedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_draft_started_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtTimestampGte() {
        return filterDraftStartedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_staged_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterStagedAtTimestampLte() {
        return filterStagedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_staged_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterStagedAtTimestampGte() {
        return filterStagedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_in_progress_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterInProgressAtTimestampLte() {
        return filterInProgressAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_in_progress_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterInProgressAtTimestampGte() {
        return filterInProgressAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_completed_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterCompletedAtTimestampLte() {
        return filterCompletedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_completed_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterCompletedAtTimestampGte() {
        return filterCompletedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_skipped_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterSkippedAtTimestampLte() {
        return filterSkippedAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_skipped_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterSkippedAtTimestampGte() {
        return filterSkippedAtTimestampGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_exception_at_timestamp_lte")
    private Optional<OffsetDateTime> _getFilterExceptionAtTimestampLte() {
        return filterExceptionAtTimestampLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_exception_at_timestamp_gte")
    private Optional<OffsetDateTime> _getFilterExceptionAtTimestampGte() {
        return filterExceptionAtTimestampGte;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ExpandedListForCourierDriverV1Request
                && equalTo((ExpandedListForCourierDriverV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpandedListForCourierDriverV1Request other) {
        return filterStatus.equals(other.filterStatus)
                && sortBy.equals(other.sortBy)
                && sortOrder.equals(other.sortOrder)
                && page.equals(other.page)
                && pageSize.equals(other.pageSize)
                && filterDraftStartedAtTimestampLte.equals(other.filterDraftStartedAtTimestampLte)
                && filterDraftStartedAtTimestampGte.equals(other.filterDraftStartedAtTimestampGte)
                && filterStagedAtTimestampLte.equals(other.filterStagedAtTimestampLte)
                && filterStagedAtTimestampGte.equals(other.filterStagedAtTimestampGte)
                && filterInProgressAtTimestampLte.equals(other.filterInProgressAtTimestampLte)
                && filterInProgressAtTimestampGte.equals(other.filterInProgressAtTimestampGte)
                && filterCompletedAtTimestampLte.equals(other.filterCompletedAtTimestampLte)
                && filterCompletedAtTimestampGte.equals(other.filterCompletedAtTimestampGte)
                && filterSkippedAtTimestampLte.equals(other.filterSkippedAtTimestampLte)
                && filterSkippedAtTimestampGte.equals(other.filterSkippedAtTimestampGte)
                && filterExceptionAtTimestampLte.equals(other.filterExceptionAtTimestampLte)
                && filterExceptionAtTimestampGte.equals(other.filterExceptionAtTimestampGte)
                && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.filterStatus,
                this.sortBy,
                this.sortOrder,
                this.page,
                this.pageSize,
                this.filterDraftStartedAtTimestampLte,
                this.filterDraftStartedAtTimestampGte,
                this.filterStagedAtTimestampLte,
                this.filterStagedAtTimestampGte,
                this.filterInProgressAtTimestampLte,
                this.filterInProgressAtTimestampGte,
                this.filterCompletedAtTimestampLte,
                this.filterCompletedAtTimestampGte,
                this.filterSkippedAtTimestampLte,
                this.filterSkippedAtTimestampGte,
                this.filterExceptionAtTimestampLte,
                this.filterExceptionAtTimestampGte,
                this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    public interface BodyStage {
        _FinalStage body(@NotNull OrderAndTaskGroupExpandedReq body);

        Builder from(ExpandedListForCourierDriverV1Request other);
    }

    public interface _FinalStage {
        ExpandedListForCourierDriverV1Request build();

        _FinalStage filterStatus(Optional<List<TaskGroupStatusEnum1>> filterStatus);

        _FinalStage filterStatus(List<TaskGroupStatusEnum1> filterStatus);

        _FinalStage filterStatus(Nullable<List<TaskGroupStatusEnum1>> filterStatus);

        _FinalStage filterStatus(TaskGroupStatusEnum1 filterStatus);

        _FinalStage sortBy(Optional<TaskGroupSortByEnum> sortBy);

        _FinalStage sortBy(TaskGroupSortByEnum sortBy);

        _FinalStage sortBy(Nullable<TaskGroupSortByEnum> sortBy);

        _FinalStage sortOrder(Optional<ExpandedListForCourierDriverV1RequestSortOrder> sortOrder);

        _FinalStage sortOrder(ExpandedListForCourierDriverV1RequestSortOrder sortOrder);

        _FinalStage sortOrder(Nullable<ExpandedListForCourierDriverV1RequestSortOrder> sortOrder);

        _FinalStage page(Optional<Integer> page);

        _FinalStage page(Integer page);

        _FinalStage page(Nullable<Integer> page);

        _FinalStage pageSize(Optional<Integer> pageSize);

        _FinalStage pageSize(Integer pageSize);

        _FinalStage pageSize(Nullable<Integer> pageSize);

        _FinalStage filterDraftStartedAtTimestampLte(Optional<OffsetDateTime> filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampLte(OffsetDateTime filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampLte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampLte);

        _FinalStage filterDraftStartedAtTimestampGte(Optional<OffsetDateTime> filterDraftStartedAtTimestampGte);

        _FinalStage filterDraftStartedAtTimestampGte(OffsetDateTime filterDraftStartedAtTimestampGte);

        _FinalStage filterDraftStartedAtTimestampGte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampGte);

        _FinalStage filterStagedAtTimestampLte(Optional<OffsetDateTime> filterStagedAtTimestampLte);

        _FinalStage filterStagedAtTimestampLte(OffsetDateTime filterStagedAtTimestampLte);

        _FinalStage filterStagedAtTimestampLte(Nullable<OffsetDateTime> filterStagedAtTimestampLte);

        _FinalStage filterStagedAtTimestampGte(Optional<OffsetDateTime> filterStagedAtTimestampGte);

        _FinalStage filterStagedAtTimestampGte(OffsetDateTime filterStagedAtTimestampGte);

        _FinalStage filterStagedAtTimestampGte(Nullable<OffsetDateTime> filterStagedAtTimestampGte);

        _FinalStage filterInProgressAtTimestampLte(Optional<OffsetDateTime> filterInProgressAtTimestampLte);

        _FinalStage filterInProgressAtTimestampLte(OffsetDateTime filterInProgressAtTimestampLte);

        _FinalStage filterInProgressAtTimestampLte(Nullable<OffsetDateTime> filterInProgressAtTimestampLte);

        _FinalStage filterInProgressAtTimestampGte(Optional<OffsetDateTime> filterInProgressAtTimestampGte);

        _FinalStage filterInProgressAtTimestampGte(OffsetDateTime filterInProgressAtTimestampGte);

        _FinalStage filterInProgressAtTimestampGte(Nullable<OffsetDateTime> filterInProgressAtTimestampGte);

        _FinalStage filterCompletedAtTimestampLte(Optional<OffsetDateTime> filterCompletedAtTimestampLte);

        _FinalStage filterCompletedAtTimestampLte(OffsetDateTime filterCompletedAtTimestampLte);

        _FinalStage filterCompletedAtTimestampLte(Nullable<OffsetDateTime> filterCompletedAtTimestampLte);

        _FinalStage filterCompletedAtTimestampGte(Optional<OffsetDateTime> filterCompletedAtTimestampGte);

        _FinalStage filterCompletedAtTimestampGte(OffsetDateTime filterCompletedAtTimestampGte);

        _FinalStage filterCompletedAtTimestampGte(Nullable<OffsetDateTime> filterCompletedAtTimestampGte);

        _FinalStage filterSkippedAtTimestampLte(Optional<OffsetDateTime> filterSkippedAtTimestampLte);

        _FinalStage filterSkippedAtTimestampLte(OffsetDateTime filterSkippedAtTimestampLte);

        _FinalStage filterSkippedAtTimestampLte(Nullable<OffsetDateTime> filterSkippedAtTimestampLte);

        _FinalStage filterSkippedAtTimestampGte(Optional<OffsetDateTime> filterSkippedAtTimestampGte);

        _FinalStage filterSkippedAtTimestampGte(OffsetDateTime filterSkippedAtTimestampGte);

        _FinalStage filterSkippedAtTimestampGte(Nullable<OffsetDateTime> filterSkippedAtTimestampGte);

        _FinalStage filterExceptionAtTimestampLte(Optional<OffsetDateTime> filterExceptionAtTimestampLte);

        _FinalStage filterExceptionAtTimestampLte(OffsetDateTime filterExceptionAtTimestampLte);

        _FinalStage filterExceptionAtTimestampLte(Nullable<OffsetDateTime> filterExceptionAtTimestampLte);

        _FinalStage filterExceptionAtTimestampGte(Optional<OffsetDateTime> filterExceptionAtTimestampGte);

        _FinalStage filterExceptionAtTimestampGte(OffsetDateTime filterExceptionAtTimestampGte);

        _FinalStage filterExceptionAtTimestampGte(Nullable<OffsetDateTime> filterExceptionAtTimestampGte);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements BodyStage, _FinalStage {
        private OrderAndTaskGroupExpandedReq body;

        private Optional<OffsetDateTime> filterExceptionAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterExceptionAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterSkippedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterSkippedAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterCompletedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterCompletedAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterInProgressAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterInProgressAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterStagedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterStagedAtTimestampLte = Optional.empty();

        private Optional<OffsetDateTime> filterDraftStartedAtTimestampGte = Optional.empty();

        private Optional<OffsetDateTime> filterDraftStartedAtTimestampLte = Optional.empty();

        private Optional<Integer> pageSize = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<ExpandedListForCourierDriverV1RequestSortOrder> sortOrder = Optional.empty();

        private Optional<TaskGroupSortByEnum> sortBy = Optional.empty();

        private Optional<List<TaskGroupStatusEnum1>> filterStatus = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ExpandedListForCourierDriverV1Request other) {
            filterStatus(other.getFilterStatus());
            sortBy(other.getSortBy());
            sortOrder(other.getSortOrder());
            page(other.getPage());
            pageSize(other.getPageSize());
            filterDraftStartedAtTimestampLte(other.getFilterDraftStartedAtTimestampLte());
            filterDraftStartedAtTimestampGte(other.getFilterDraftStartedAtTimestampGte());
            filterStagedAtTimestampLte(other.getFilterStagedAtTimestampLte());
            filterStagedAtTimestampGte(other.getFilterStagedAtTimestampGte());
            filterInProgressAtTimestampLte(other.getFilterInProgressAtTimestampLte());
            filterInProgressAtTimestampGte(other.getFilterInProgressAtTimestampGte());
            filterCompletedAtTimestampLte(other.getFilterCompletedAtTimestampLte());
            filterCompletedAtTimestampGte(other.getFilterCompletedAtTimestampGte());
            filterSkippedAtTimestampLte(other.getFilterSkippedAtTimestampLte());
            filterSkippedAtTimestampGte(other.getFilterSkippedAtTimestampGte());
            filterExceptionAtTimestampLte(other.getFilterExceptionAtTimestampLte());
            filterExceptionAtTimestampGte(other.getFilterExceptionAtTimestampGte());
            body(other.getBody());
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull OrderAndTaskGroupExpandedReq body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage filterExceptionAtTimestampGte(Nullable<OffsetDateTime> filterExceptionAtTimestampGte) {
            if (filterExceptionAtTimestampGte.isNull()) {
                this.filterExceptionAtTimestampGte = null;
            } else if (filterExceptionAtTimestampGte.isEmpty()) {
                this.filterExceptionAtTimestampGte = Optional.empty();
            } else {
                this.filterExceptionAtTimestampGte = Optional.of(filterExceptionAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterExceptionAtTimestampGte(OffsetDateTime filterExceptionAtTimestampGte) {
            this.filterExceptionAtTimestampGte = Optional.ofNullable(filterExceptionAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_exception_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterExceptionAtTimestampGte(Optional<OffsetDateTime> filterExceptionAtTimestampGte) {
            this.filterExceptionAtTimestampGte = filterExceptionAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterExceptionAtTimestampLte(Nullable<OffsetDateTime> filterExceptionAtTimestampLte) {
            if (filterExceptionAtTimestampLte.isNull()) {
                this.filterExceptionAtTimestampLte = null;
            } else if (filterExceptionAtTimestampLte.isEmpty()) {
                this.filterExceptionAtTimestampLte = Optional.empty();
            } else {
                this.filterExceptionAtTimestampLte = Optional.of(filterExceptionAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterExceptionAtTimestampLte(OffsetDateTime filterExceptionAtTimestampLte) {
            this.filterExceptionAtTimestampLte = Optional.ofNullable(filterExceptionAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_exception_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterExceptionAtTimestampLte(Optional<OffsetDateTime> filterExceptionAtTimestampLte) {
            this.filterExceptionAtTimestampLte = filterExceptionAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterSkippedAtTimestampGte(Nullable<OffsetDateTime> filterSkippedAtTimestampGte) {
            if (filterSkippedAtTimestampGte.isNull()) {
                this.filterSkippedAtTimestampGte = null;
            } else if (filterSkippedAtTimestampGte.isEmpty()) {
                this.filterSkippedAtTimestampGte = Optional.empty();
            } else {
                this.filterSkippedAtTimestampGte = Optional.of(filterSkippedAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterSkippedAtTimestampGte(OffsetDateTime filterSkippedAtTimestampGte) {
            this.filterSkippedAtTimestampGte = Optional.ofNullable(filterSkippedAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_skipped_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterSkippedAtTimestampGte(Optional<OffsetDateTime> filterSkippedAtTimestampGte) {
            this.filterSkippedAtTimestampGte = filterSkippedAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterSkippedAtTimestampLte(Nullable<OffsetDateTime> filterSkippedAtTimestampLte) {
            if (filterSkippedAtTimestampLte.isNull()) {
                this.filterSkippedAtTimestampLte = null;
            } else if (filterSkippedAtTimestampLte.isEmpty()) {
                this.filterSkippedAtTimestampLte = Optional.empty();
            } else {
                this.filterSkippedAtTimestampLte = Optional.of(filterSkippedAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterSkippedAtTimestampLte(OffsetDateTime filterSkippedAtTimestampLte) {
            this.filterSkippedAtTimestampLte = Optional.ofNullable(filterSkippedAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_skipped_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterSkippedAtTimestampLte(Optional<OffsetDateTime> filterSkippedAtTimestampLte) {
            this.filterSkippedAtTimestampLte = filterSkippedAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtTimestampGte(Nullable<OffsetDateTime> filterCompletedAtTimestampGte) {
            if (filterCompletedAtTimestampGte.isNull()) {
                this.filterCompletedAtTimestampGte = null;
            } else if (filterCompletedAtTimestampGte.isEmpty()) {
                this.filterCompletedAtTimestampGte = Optional.empty();
            } else {
                this.filterCompletedAtTimestampGte = Optional.of(filterCompletedAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtTimestampGte(OffsetDateTime filterCompletedAtTimestampGte) {
            this.filterCompletedAtTimestampGte = Optional.ofNullable(filterCompletedAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_completed_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterCompletedAtTimestampGte(Optional<OffsetDateTime> filterCompletedAtTimestampGte) {
            this.filterCompletedAtTimestampGte = filterCompletedAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtTimestampLte(Nullable<OffsetDateTime> filterCompletedAtTimestampLte) {
            if (filterCompletedAtTimestampLte.isNull()) {
                this.filterCompletedAtTimestampLte = null;
            } else if (filterCompletedAtTimestampLte.isEmpty()) {
                this.filterCompletedAtTimestampLte = Optional.empty();
            } else {
                this.filterCompletedAtTimestampLte = Optional.of(filterCompletedAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterCompletedAtTimestampLte(OffsetDateTime filterCompletedAtTimestampLte) {
            this.filterCompletedAtTimestampLte = Optional.ofNullable(filterCompletedAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_completed_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterCompletedAtTimestampLte(Optional<OffsetDateTime> filterCompletedAtTimestampLte) {
            this.filterCompletedAtTimestampLte = filterCompletedAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterInProgressAtTimestampGte(Nullable<OffsetDateTime> filterInProgressAtTimestampGte) {
            if (filterInProgressAtTimestampGte.isNull()) {
                this.filterInProgressAtTimestampGte = null;
            } else if (filterInProgressAtTimestampGte.isEmpty()) {
                this.filterInProgressAtTimestampGte = Optional.empty();
            } else {
                this.filterInProgressAtTimestampGte = Optional.of(filterInProgressAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterInProgressAtTimestampGte(OffsetDateTime filterInProgressAtTimestampGte) {
            this.filterInProgressAtTimestampGte = Optional.ofNullable(filterInProgressAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_in_progress_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterInProgressAtTimestampGte(Optional<OffsetDateTime> filterInProgressAtTimestampGte) {
            this.filterInProgressAtTimestampGte = filterInProgressAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterInProgressAtTimestampLte(Nullable<OffsetDateTime> filterInProgressAtTimestampLte) {
            if (filterInProgressAtTimestampLte.isNull()) {
                this.filterInProgressAtTimestampLte = null;
            } else if (filterInProgressAtTimestampLte.isEmpty()) {
                this.filterInProgressAtTimestampLte = Optional.empty();
            } else {
                this.filterInProgressAtTimestampLte = Optional.of(filterInProgressAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterInProgressAtTimestampLte(OffsetDateTime filterInProgressAtTimestampLte) {
            this.filterInProgressAtTimestampLte = Optional.ofNullable(filterInProgressAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_in_progress_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterInProgressAtTimestampLte(Optional<OffsetDateTime> filterInProgressAtTimestampLte) {
            this.filterInProgressAtTimestampLte = filterInProgressAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStagedAtTimestampGte(Nullable<OffsetDateTime> filterStagedAtTimestampGte) {
            if (filterStagedAtTimestampGte.isNull()) {
                this.filterStagedAtTimestampGte = null;
            } else if (filterStagedAtTimestampGte.isEmpty()) {
                this.filterStagedAtTimestampGte = Optional.empty();
            } else {
                this.filterStagedAtTimestampGte = Optional.of(filterStagedAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStagedAtTimestampGte(OffsetDateTime filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = Optional.ofNullable(filterStagedAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_staged_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterStagedAtTimestampGte(Optional<OffsetDateTime> filterStagedAtTimestampGte) {
            this.filterStagedAtTimestampGte = filterStagedAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStagedAtTimestampLte(Nullable<OffsetDateTime> filterStagedAtTimestampLte) {
            if (filterStagedAtTimestampLte.isNull()) {
                this.filterStagedAtTimestampLte = null;
            } else if (filterStagedAtTimestampLte.isEmpty()) {
                this.filterStagedAtTimestampLte = Optional.empty();
            } else {
                this.filterStagedAtTimestampLte = Optional.of(filterStagedAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStagedAtTimestampLte(OffsetDateTime filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = Optional.ofNullable(filterStagedAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_staged_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterStagedAtTimestampLte(Optional<OffsetDateTime> filterStagedAtTimestampLte) {
            this.filterStagedAtTimestampLte = filterStagedAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampGte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampGte) {
            if (filterDraftStartedAtTimestampGte.isNull()) {
                this.filterDraftStartedAtTimestampGte = null;
            } else if (filterDraftStartedAtTimestampGte.isEmpty()) {
                this.filterDraftStartedAtTimestampGte = Optional.empty();
            } else {
                this.filterDraftStartedAtTimestampGte = Optional.of(filterDraftStartedAtTimestampGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampGte(OffsetDateTime filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = Optional.ofNullable(filterDraftStartedAtTimestampGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_draft_started_at_timestamp_gte", nulls = Nulls.SKIP)
        public _FinalStage filterDraftStartedAtTimestampGte(Optional<OffsetDateTime> filterDraftStartedAtTimestampGte) {
            this.filterDraftStartedAtTimestampGte = filterDraftStartedAtTimestampGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampLte(Nullable<OffsetDateTime> filterDraftStartedAtTimestampLte) {
            if (filterDraftStartedAtTimestampLte.isNull()) {
                this.filterDraftStartedAtTimestampLte = null;
            } else if (filterDraftStartedAtTimestampLte.isEmpty()) {
                this.filterDraftStartedAtTimestampLte = Optional.empty();
            } else {
                this.filterDraftStartedAtTimestampLte = Optional.of(filterDraftStartedAtTimestampLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtTimestampLte(OffsetDateTime filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = Optional.ofNullable(filterDraftStartedAtTimestampLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_draft_started_at_timestamp_lte", nulls = Nulls.SKIP)
        public _FinalStage filterDraftStartedAtTimestampLte(Optional<OffsetDateTime> filterDraftStartedAtTimestampLte) {
            this.filterDraftStartedAtTimestampLte = filterDraftStartedAtTimestampLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Nullable<Integer> pageSize) {
            if (pageSize.isNull()) {
                this.pageSize = null;
            } else if (pageSize.isEmpty()) {
                this.pageSize = Optional.empty();
            } else {
                this.pageSize = Optional.of(pageSize.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page_size", nulls = Nulls.SKIP)
        public _FinalStage pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Nullable<Integer> page) {
            if (page.isNull()) {
                this.page = null;
            } else if (page.isEmpty()) {
                this.page = Optional.empty();
            } else {
                this.page = Optional.of(page.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(Nullable<ExpandedListForCourierDriverV1RequestSortOrder> sortOrder) {
            if (sortOrder.isNull()) {
                this.sortOrder = null;
            } else if (sortOrder.isEmpty()) {
                this.sortOrder = Optional.empty();
            } else {
                this.sortOrder = Optional.of(sortOrder.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(ExpandedListForCourierDriverV1RequestSortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_order", nulls = Nulls.SKIP)
        public _FinalStage sortOrder(Optional<ExpandedListForCourierDriverV1RequestSortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(Nullable<TaskGroupSortByEnum> sortBy) {
            if (sortBy.isNull()) {
                this.sortBy = null;
            } else if (sortBy.isEmpty()) {
                this.sortBy = Optional.empty();
            } else {
                this.sortBy = Optional.of(sortBy.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(TaskGroupSortByEnum sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_by", nulls = Nulls.SKIP)
        public _FinalStage sortBy(Optional<TaskGroupSortByEnum> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatus(TaskGroupStatusEnum1 filterStatus) {
            this.filterStatus = Optional.of(Collections.singletonList(filterStatus));
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatus(Nullable<List<TaskGroupStatusEnum1>> filterStatus) {
            if (filterStatus.isNull()) {
                this.filterStatus = null;
            } else if (filterStatus.isEmpty()) {
                this.filterStatus = Optional.empty();
            } else {
                this.filterStatus = Optional.of(filterStatus.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatus(List<TaskGroupStatusEnum1> filterStatus) {
            this.filterStatus = Optional.ofNullable(filterStatus);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_status", nulls = Nulls.SKIP)
        public _FinalStage filterStatus(Optional<List<TaskGroupStatusEnum1>> filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        @java.lang.Override
        public ExpandedListForCourierDriverV1Request build() {
            return new ExpandedListForCourierDriverV1Request(
                    filterStatus,
                    sortBy,
                    sortOrder,
                    page,
                    pageSize,
                    filterDraftStartedAtTimestampLte,
                    filterDraftStartedAtTimestampGte,
                    filterStagedAtTimestampLte,
                    filterStagedAtTimestampGte,
                    filterInProgressAtTimestampLte,
                    filterInProgressAtTimestampGte,
                    filterCompletedAtTimestampLte,
                    filterCompletedAtTimestampGte,
                    filterSkippedAtTimestampLte,
                    filterSkippedAtTimestampGte,
                    filterExceptionAtTimestampLte,
                    filterExceptionAtTimestampGte,
                    body,
                    additionalProperties);
        }
    }
}
