/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SetTaskOrderingReq.Builder.class)
public final class SetTaskOrderingReq {
    private final List<String> taskIds;

    private final Map<String, Object> additionalProperties;

    private SetTaskOrderingReq(List<String> taskIds, Map<String, Object> additionalProperties) {
        this.taskIds = taskIds;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Complete list of task IDs in the desired order
     */
    @JsonProperty("task_ids")
    public List<String> getTaskIds() {
        return taskIds;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SetTaskOrderingReq && equalTo((SetTaskOrderingReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SetTaskOrderingReq other) {
        return taskIds.equals(other.taskIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.taskIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<String> taskIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SetTaskOrderingReq other) {
            taskIds(other.getTaskIds());
            return this;
        }

        /**
         * <p>Complete list of task IDs in the desired order</p>
         */
        @JsonSetter(value = "task_ids", nulls = Nulls.SKIP)
        public Builder taskIds(List<String> taskIds) {
            this.taskIds.clear();
            if (taskIds != null) {
                this.taskIds.addAll(taskIds);
            }
            return this;
        }

        public Builder addTaskIds(String taskIds) {
            this.taskIds.add(taskIds);
            return this;
        }

        public Builder addAllTaskIds(List<String> taskIds) {
            if (taskIds != null) {
                this.taskIds.addAll(taskIds);
            }
            return this;
        }

        public SetTaskOrderingReq build() {
            return new SetTaskOrderingReq(taskIds, additionalProperties);
        }
    }
}
