/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateDriverReq.Builder.class)
public final class UpdateDriverReq {
    private final String driverId;

    private final Map<String, Object> additionalProperties;

    private UpdateDriverReq(String driverId, Map<String, Object> additionalProperties) {
        this.driverId = driverId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return ID of the driver to assign to the task group
     */
    @JsonProperty("driver_id")
    public String getDriverId() {
        return driverId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateDriverReq && equalTo((UpdateDriverReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateDriverReq other) {
        return driverId.equals(other.driverId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.driverId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DriverIdStage builder() {
        return new Builder();
    }

    public interface DriverIdStage {
        /**
         * <p>ID of the driver to assign to the task group</p>
         */
        _FinalStage driverId(@NotNull String driverId);

        Builder from(UpdateDriverReq other);
    }

    public interface _FinalStage {
        UpdateDriverReq build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DriverIdStage, _FinalStage {
        private String driverId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateDriverReq other) {
            driverId(other.getDriverId());
            return this;
        }

        /**
         * <p>ID of the driver to assign to the task group</p>
         * <p>ID of the driver to assign to the task group</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("driver_id")
        public _FinalStage driverId(@NotNull String driverId) {
            this.driverId = Objects.requireNonNull(driverId, "driverId must not be null");
            return this;
        }

        @java.lang.Override
        public UpdateDriverReq build() {
            return new UpdateDriverReq(driverId, additionalProperties);
        }
    }
}
