/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.s3object;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskgroups.s3object.requests.BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost;
import com.chrt.api.types.TaskGroupS3ObjectMetadata1;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public class AsyncS3ObjectClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawS3ObjectClient rawClient;

    public AsyncS3ObjectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawS3ObjectClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawS3ObjectClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the metadata for a task group S3 object, including blurhash for placeholder loading. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (TaskGroupS3ObjectMetadata1)
     */
    public CompletableFuture<TaskGroupS3ObjectMetadata1> getS3ObjectMetadataV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.getS3ObjectMetadataV1(taskGroupS3ObjectMetadataId).thenApply(response -> response.body());
    }

    /**
     * Retrieves the metadata for a task group S3 object, including blurhash for placeholder loading. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (TaskGroupS3ObjectMetadata1)
     */
    public CompletableFuture<TaskGroupS3ObjectMetadata1> getS3ObjectMetadataV1(
            String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .getS3ObjectMetadataV1(taskGroupS3ObjectMetadataId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Streams a task group S3 object file from storage. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (binary)
     */
    public CompletableFuture<InputStream> getV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.getV1(taskGroupS3ObjectMetadataId).thenApply(response -> response.body());
    }

    /**
     * Streams a task group S3 object file from storage. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (binary)
     */
    public CompletableFuture<InputStream> getV1(String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient.getV1(taskGroupS3ObjectMetadataId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Uploads an image file to a task group with automatic blurhash generation. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators, shipper_org_operators] | (UploadFile) -&gt; (bool)
     */
    public CompletableFuture<Boolean> addV1(
            String taskGroupId,
            File image,
            BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost request) {
        return this.rawClient.addV1(taskGroupId, image, request).thenApply(response -> response.body());
    }

    /**
     * Uploads an image file to a task group with automatic blurhash generation. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators, shipper_org_operators] | (UploadFile) -&gt; (bool)
     */
    public CompletableFuture<Boolean> addV1(
            String taskGroupId,
            File image,
            BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost request,
            RequestOptions requestOptions) {
        return this.rawClient.addV1(taskGroupId, image, request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes an S3 object metadata and the associated S3 object from a task group. Only the uploader or an operator from the uploading org can delete. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.deleteV1(taskGroupS3ObjectMetadataId).thenApply(response -> response.body());
    }

    /**
     * Deletes an S3 object metadata and the associated S3 object from a task group. Only the uploader or an operator from the uploading org can delete. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteV1(taskGroupS3ObjectMetadataId, requestOptions)
                .thenApply(response -> response.body());
    }
}
