/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.s3object;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskgroups.s3object.requests.BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost;
import com.chrt.api.types.TaskGroupS3ObjectMetadata1;
import java.io.File;
import java.io.InputStream;

public class S3ObjectClient {
    protected final ClientOptions clientOptions;

    private final RawS3ObjectClient rawClient;

    public S3ObjectClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawS3ObjectClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawS3ObjectClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the metadata for a task group S3 object, including blurhash for placeholder loading. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (TaskGroupS3ObjectMetadata1)
     */
    public TaskGroupS3ObjectMetadata1 getS3ObjectMetadataV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.getS3ObjectMetadataV1(taskGroupS3ObjectMetadataId).body();
    }

    /**
     * Retrieves the metadata for a task group S3 object, including blurhash for placeholder loading. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (TaskGroupS3ObjectMetadata1)
     */
    public TaskGroupS3ObjectMetadata1 getS3ObjectMetadataV1(
            String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .getS3ObjectMetadataV1(taskGroupS3ObjectMetadataId, requestOptions)
                .body();
    }

    /**
     * Streams a task group S3 object file from storage. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (binary)
     */
    public InputStream getV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.getV1(taskGroupS3ObjectMetadataId).body();
    }

    /**
     * Streams a task group S3 object file from storage. | authz_personas=[courier_driver, courier_org_operators, shipper_org_operators, forwarder_org_operators] | () -&gt; (binary)
     */
    public InputStream getV1(String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient.getV1(taskGroupS3ObjectMetadataId, requestOptions).body();
    }

    /**
     * Uploads an image file to a task group with automatic blurhash generation. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators, shipper_org_operators] | (UploadFile) -&gt; (bool)
     */
    public boolean addV1(
            String taskGroupId,
            File image,
            BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost request) {
        return this.rawClient.addV1(taskGroupId, image, request).body();
    }

    /**
     * Uploads an image file to a task group with automatic blurhash generation. | authz_personas=[courier_driver, courier_org_operators, forwarder_org_operators, shipper_org_operators] | (UploadFile) -&gt; (bool)
     */
    public boolean addV1(
            String taskGroupId,
            File image,
            BodyPostTaskGroupsS3ObjectAddV1OortTaskGroupsS3ObjectAddV1TaskGroupIdPost request,
            RequestOptions requestOptions) {
        return this.rawClient.addV1(taskGroupId, image, request, requestOptions).body();
    }

    /**
     * Deletes an S3 object metadata and the associated S3 object from a task group. Only the uploader or an operator from the uploading org can delete. | () -&gt; (bool)
     */
    public boolean deleteV1(String taskGroupS3ObjectMetadataId) {
        return this.rawClient.deleteV1(taskGroupS3ObjectMetadataId).body();
    }

    /**
     * Deletes an S3 object metadata and the associated S3 object from a task group. Only the uploader or an operator from the uploading org can delete. | () -&gt; (bool)
     */
    public boolean deleteV1(String taskGroupS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteV1(taskGroupS3ObjectMetadataId, requestOptions)
                .body();
    }
}
