/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskgroups.taskgroupid;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;

public class TaskGroupIdClient {
    protected final ClientOptions clientOptions;

    private final RawTaskGroupIdClient rawClient;

    public TaskGroupIdClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskGroupIdClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTaskGroupIdClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the task group ID for the courier organization assigned to an order's task group. | authz_personas=[courier_org_operators] | () -&gt; (PydanticObjectId)
     */
    public String forCourierOperatorsV1(String orderIdOrShortId) {
        return this.rawClient.forCourierOperatorsV1(orderIdOrShortId).body();
    }

    /**
     * Retrieves the task group ID for the courier organization assigned to an order's task group. | authz_personas=[courier_org_operators] | () -&gt; (PydanticObjectId)
     */
    public String forCourierOperatorsV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient
                .forCourierOperatorsV1(orderIdOrShortId, requestOptions)
                .body();
    }

    /**
     * Retrieves the task group ID for the courier driver assigned to an order's task group. | authz_personas=[courier_driver] | () -&gt; (PydanticObjectId)
     */
    public String forCourierDriverV1(String orderIdOrShortId) {
        return this.rawClient.forCourierDriverV1(orderIdOrShortId).body();
    }

    /**
     * Retrieves the task group ID for the courier driver assigned to an order's task group. | authz_personas=[courier_driver] | () -&gt; (PydanticObjectId)
     */
    public String forCourierDriverV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient
                .forCourierDriverV1(orderIdOrShortId, requestOptions)
                .body();
    }
}
