/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tasks;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.tasks.requests.AddTaskToGroupReq;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.TaskClientUpdate1;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawTasksClient {
    protected final ClientOptions clientOptions;

    public AsyncRawTasksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Adds a new task to a task group at a specific index. | authz_personas=[lig_org_operators] | (AddTaskToGroupReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<ChrtApiHttpResponse<String>> addToTaskGroupV1(
            String taskGroupId, AddTaskToGroupReq request) {
        return addToTaskGroupV1(taskGroupId, request, null);
    }

    /**
     * Adds a new task to a task group at a specific index. | authz_personas=[lig_org_operators] | (AddTaskToGroupReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<ChrtApiHttpResponse<String>> addToTaskGroupV1(
            String taskGroupId, AddTaskToGroupReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/tasks/add_to_task_group/v1")
                .addPathSegment(taskGroupId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<String>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<ChrtApiHttpResponse<String>> updateV1(String taskId) {
        return updateV1(taskId, TaskClientUpdate1.builder().build());
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<ChrtApiHttpResponse<String>> updateV1(String taskId, TaskClientUpdate1 request) {
        return updateV1(taskId, request, null);
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<ChrtApiHttpResponse<String>> updateV1(
            String taskId, TaskClientUpdate1 request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/tasks/update/v1")
                .addPathSegment(taskId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PATCH", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<String>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Marks a task as COMPLETED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> completeV1(String taskId) {
        return completeV1(taskId, null);
    }

    /**
     * Marks a task as COMPLETED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> completeV1(String taskId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/tasks/complete/v1")
                .addPathSegment(taskId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Marks a task as SKIPPED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> skipV1(String taskId) {
        return skipV1(taskId, null);
    }

    /**
     * Marks a task as SKIPPED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> skipV1(String taskId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/tasks/skip/v1")
                .addPathSegment(taskId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Deletes a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> deleteV1(String taskId) {
        return deleteV1(taskId, null);
    }

    /**
     * Deletes a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<ChrtApiHttpResponse<Boolean>> deleteV1(String taskId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/tasks/delete/v1")
                .addPathSegment(taskId)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<Boolean>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, boolean.class), response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
