/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.tasks;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.tasks.requests.AddTaskToGroupReq;
import com.chrt.api.types.TaskClientUpdate1;
import java.util.concurrent.CompletableFuture;

public class AsyncTasksClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTasksClient rawClient;

    public AsyncTasksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTasksClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTasksClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a new task to a task group at a specific index. | authz_personas=[lig_org_operators] | (AddTaskToGroupReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> addToTaskGroupV1(String taskGroupId, AddTaskToGroupReq request) {
        return this.rawClient.addToTaskGroupV1(taskGroupId, request).thenApply(response -> response.body());
    }

    /**
     * Adds a new task to a task group at a specific index. | authz_personas=[lig_org_operators] | (AddTaskToGroupReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> addToTaskGroupV1(
            String taskGroupId, AddTaskToGroupReq request, RequestOptions requestOptions) {
        return this.rawClient
                .addToTaskGroupV1(taskGroupId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> updateV1(String taskId) {
        return this.rawClient.updateV1(taskId).thenApply(response -> response.body());
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> updateV1(String taskId, TaskClientUpdate1 request) {
        return this.rawClient.updateV1(taskId, request).thenApply(response -> response.body());
    }

    /**
     * Updates a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | (TaskClientUpdate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> updateV1(String taskId, TaskClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(taskId, request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Marks a task as COMPLETED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> completeV1(String taskId) {
        return this.rawClient.completeV1(taskId).thenApply(response -> response.body());
    }

    /**
     * Marks a task as COMPLETED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> completeV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.completeV1(taskId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Marks a task as SKIPPED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> skipV1(String taskId) {
        return this.rawClient.skipV1(taskId).thenApply(response -> response.body());
    }

    /**
     * Marks a task as SKIPPED. | authz_personas=[courier_driver, forwarder_org_operators, courier_org_operators] (depending on type) | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> skipV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.skipV1(taskId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskId) {
        return this.rawClient.deleteV1(taskId).thenApply(response -> response.body());
    }

    /**
     * Deletes a task. Task must be in STAGED status. | authz_personas=[lig_org_operators] | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> deleteV1(String taskId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskId, requestOptions).thenApply(response -> response.body());
    }
}
